% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolpower_t.R
\name{poolpower_t}
\alias{poolpower_t}
\title{Visualize T-test Power for Pooling Design}
\usage{
poolpower_t(g = c(1, 3, 10), d = NULL, mu1 = NULL, mu2 = NULL,
  sigsq = NULL, sigsq1 = sigsq, sigsq2 = sigsq, sigsq_p = 0,
  sigsq_m = 0, multiplicative = FALSE, alpha = 0.05, beta = 0.2,
  assay_cost = 100, other_costs = 0, labels = TRUE)
}
\arguments{
\item{g}{Numeric vector of pool sizes to include.}

\item{d}{Numeric value specifying true difference in group means.}

\item{mu1, mu2}{Numeric value specifying group means. Required if
\code{multiplicative = TRUE}.}

\item{sigsq}{Numeric value specifying the variance of observations.}

\item{sigsq1, sigsq2}{Numeric value specifying the variance of observations
for each group.}

\item{sigsq_p}{Numeric value specifying the variance of processing errors.}

\item{sigsq_m}{Numeric value specifying the variance of measurement errors.}

\item{multiplicative}{Logical value for whether to assume multiplicative
rather than additive errors.}

\item{alpha}{Numeric value specifying type-1 error rate.}

\item{beta}{Numeric value specifying type-2 error rate.}

\item{assay_cost}{Numeric value specifying cost of each assay.}

\item{other_costs}{Numeric value specifying other per-subject costs.}

\item{labels}{Logical value.}
}
\value{
Plot of power vs. total costs generated by
\code{\link[ggplot2]{ggplot}}.
}
\description{
Useful for assessing efficiency gains that might be achieved with a pooling
design.
}
\examples{
# Plot power vs. total study costs for d = 0.25, sigsq = 1, and costs of $100
# per assay and $0 in other per-subject costs.
poolpower_t(d = 0.5, sigsq = 1, assay_cost = 100, other_costs = 0)

# Repeat but with $10 in per-subject costs.
poolpower_t(d = 0.5, sigsq = 1, assay_cost = 100, other_costs = 10)

# Back to no per-subject costs, but with processing and measurement error
poolpower_t(d = 0.5, sigsq = 1, sigsq_p = 0.2, sigsq_m = 0.1,
            assay_cost = 100, other_costs = 0)


}
