% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spect_match.R
\docType{methods}
\name{spectrum_matching}
\alias{spectrum_matching}
\alias{spect_objfun}
\alias{spect_objfun,missing-method}
\alias{spect_objfun,ANY-method}
\alias{spect_objfun,data.frame-method}
\alias{spect_objfun,pomp-method}
\alias{spect_objfun,spectd_pomp-method}
\alias{spect_objfun,spect_match_objfun-method}
\title{Spectrum matching}
\usage{
\S4method{spect_objfun}{data.frame}(
  data,
  est = character(0),
  weights = 1,
  fail.value = NA,
  vars,
  kernel.width,
  nsim,
  seed = NULL,
  transform.data = identity,
  detrend = c("none", "mean", "linear", "quadratic"),
  params,
  rinit,
  rprocess,
  rmeasure,
  partrans,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{spect_objfun}{pomp}(
  data,
  est = character(0),
  weights = 1,
  fail.value = NA,
  vars,
  kernel.width,
  nsim,
  seed = NULL,
  transform.data = identity,
  detrend = c("none", "mean", "linear", "quadratic"),
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{spect_objfun}{spectd_pomp}(
  data,
  est = character(0),
  weights = 1,
  fail.value = NA,
  vars,
  kernel.width,
  nsim,
  seed = NULL,
  transform.data = identity,
  detrend,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{spect_objfun}{spect_match_objfun}(
  data,
  est,
  weights,
  fail.value,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.}

\item{est}{character vector; the names of parameters to be estimated.}

\item{weights}{optional numeric or function.
The mismatch between model and data is measured by a weighted average of mismatch at each frequency.
By default, all frequencies are weighted equally.
\code{weights} can be specified either as a vector (which must have length equal to the number of frequencies) or as a function of frequency.
If the latter, \code{weights(freq)} must return a nonnegative weight for each frequency.}

\item{fail.value}{optional numeric scalar;
if non-\code{NA}, this value is substituted for non-finite values of the objective function.
It should be a large number (i.e., bigger than any legitimate values the objective function is likely to take).}

\item{vars}{optional; names of observed variables for which the power spectrum will be computed.
By default, the spectrum will be computed for all observables.}

\item{kernel.width}{width parameter for the smoothing kernel used for
calculating the estimate of the spectrum.}

\item{nsim}{the number of model simulations to be computed.}

\item{seed}{integer.
When fitting, it is often best to fix the seed of the random-number generator (RNG).
This is accomplished by setting \code{seed} to an integer.
By default, \code{seed = NULL}, which does not alter the RNG state.}

\item{transform.data}{function; this transformation will be applied to the
observables prior to estimation of the spectrum, and prior to any
detrending.}

\item{detrend}{de-trending operation to perform.  Options include no
detrending, and subtraction of constant, linear, and quadratic trends from
the data.  Detrending is applied to each data series and to each model
simulation independently.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{?rinit_spec}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, \link[=rprocess_spec]{see ?rprocess_spec for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{?rmeasure_spec}.}

\item{partrans}{optional parameter transformations, constructed using \code{\link{parameter_trans}}.

Many algorithms for parameter estimation search an unconstrained space of parameters.
When working with such an algorithm and a model for which the parameters are constrained, it can be useful to transform parameters.
One should supply the \code{partrans} argument via a call to \code{\link{parameter_trans}}.
For more information, see \link[=parameter_trans]{?parameter_trans}.
Setting \code{partrans=NULL} removes the parameter transformations, i.e., sets them to the identity transformation.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{?userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{spect_objfun} constructs a stateful objective function for spectrum matching.
Specifically, \code{spect_objfun} returns an object of class \sQuote{spect_match_objfun}, which is a function suitable for use in an \code{\link{optim}}-like optimizer.
This function takes a single numeric-vector argument that is assumed to contain the parameters named in \code{est}, in that order.
When called, it will return the (optionally weighted) \eqn{L^2}{L2} distance between the data spectrum and simulated spectra.
It is a stateful function:
Each time it is called, it will remember the values of the parameters and the discrepancy measure.
}
\description{
Estimation of parameters by matching power spectra
}
\details{
In spectrum matching, one attempts to minimize the discrepancy between a \acronym{POMP} model's predictions and data, as measured in the frequency domain by the power spectrum.

\code{spect_objfun} constructs an objective function that measures the discrepancy.
It can be passed to any one of a variety of numerical optimization routines, which will adjust model parameters to minimize the discrepancies between the power spectrum of model simulations and that of the data.
}
\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{cdir} and \code{cfile} options \link[=pomp]{(described here)} to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\section{Important Note}{

Since \pkg{pomp} cannot guarantee that the \emph{final} call an optimizer makes to the function is a call \emph{at} the optimum, it cannot guarantee that the parameters stored in the function are the optimal ones.
Therefore, it is a good idea to evaluate the function on the parameters returned by the optimization routine, which will ensure that these parameters are stored.
}

\examples{
\donttest{

  ricker() \%>\%
    spect_objfun(
      est=c("r","sigma","N_0"),
      partrans=parameter_trans(log=c("r","sigma","N_0")),
      paramnames=c("r","sigma","N_0"),
      kernel.width=3,
      nsim=100,
      seed=5069977
    ) -> f

  f(log(c(20,0.3,10)))
  f \%>\% spect() \%>\% plot()

  library(subplex)
  subplex(fn=f,par=log(c(20,0.3,10)),control=list(reltol=1e-5)) -> out
  f(out$par)

  f \%>\% summary()

  f \%>\% spect() \%>\% plot()

}
}
\seealso{
\code{\link{spect}} \code{\link{optim}}
\code{\link[subplex]{subplex}} \code{\link[nloptr]{nloptr}}

More on \pkg{pomp} estimation algorithms:
\code{\link{abc}()},
\code{\link{bsmc2}()},
\code{\link{estimation_algorithms}},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{nonlinear_forecasting}},
\code{\link{pmcmc}()},
\code{\link{pomp-package}},
\code{\link{probe_matching}}
}
\concept{estimation_methods}
