% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R, R/objfun.R
\docType{methods}
\name{coef}
\alias{coef}
\alias{coef,missing-method}
\alias{coef<-,missing-method}
\alias{coef-listie}
\alias{coef,listie-method}
\alias{coef-pomp}
\alias{coef,pomp-method}
\alias{coef<--pomp}
\alias{coef<-}
\alias{coef<-,pomp-method}
\alias{coef-objfun}
\alias{coef,objfun-method}
\title{Extract, set, or alter coefficients}
\usage{
\S4method{coef}{listie}(object, ...)

\S4method{coef}{pomp}(object, pars, transform = FALSE, ...)

\S4method{coef}{pomp}(object, pars, transform = FALSE, ...) <- value

\S4method{coef}{objfun}(object, ...)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class extending \sQuote{pomp}}

\item{\dots}{ignored}

\item{pars}{optional character; names of parameters to be retrieved or set.}

\item{transform}{logical; perform parameter transformation?}

\item{value}{numeric vector or list; values to be assigned.
If \code{value = NULL}, the parameters are unset.}
}
\description{
Extract, set, or modify the estimated parameters from a fitted model.
}
\details{
\code{coef} allows one to extract the parameters from a fitted model.

\code{coef(object,transform=TRUE)} returns the parameters transformed onto
the estimation scale.

\code{coef(object) <- value} sets or alters the coefficients of a
\sQuote{pomp} object.

\code{coef(object,transform=TRUE) <- value} assumes that \code{value} is on
the estimation scale, and applies the \dQuote{from estimation scale}
parameter transformation from \code{object} before altering the
coefficients.
}
