% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe.R, R/probe_match.R, R/objfun.R
\docType{methods}
\name{probe}
\alias{probe}
\alias{probe,missing-method}
\alias{probe,ANY-method}
\alias{probe-data.frame}
\alias{probe,data.frame-method}
\alias{probe-pomp}
\alias{probe,pomp-method}
\alias{probe-probed_pomp}
\alias{probe,probed_pomp-method}
\alias{probe-probe_match_obfjun}
\alias{probe,probe_match_objfun-method}
\alias{coerce-probe_match_objfun-probed_pomp}
\alias{coerce,probe_match_objfun,probed_pomp-method}
\alias{probe-objfun}
\alias{probe,objfun-method}
\title{Probes (AKA summary statistics)}
\usage{
\S4method{probe}{data.frame}(
  data,
  probes,
  nsim,
  seed = NULL,
  params,
  rinit,
  rprocess,
  rmeasure,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe}{pomp}(
  data,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe}{probed_pomp}(
  data,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe}{probe_match_objfun}(data, seed, ..., verbose = getOption("verbose", FALSE))

\S4method{probe}{objfun}(data, seed = NULL, ...)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.}

\item{probes}{a single probe or a list of one or more probes.
A probe is simply a scalar- or vector-valued function of one argument that can be applied to the data array of a \sQuote{pomp}.
A vector-valued probe must always return a vector of the same size.
A number of useful probes are provided with the package:
see \link[=basic_probes]{basic probes}.}

\item{nsim}{the number of model simulations to be computed.}

\item{seed}{optional integer;
if non-\code{NULL}, the random number generator will be initialized with this seed for simulations.
See \code{\link[=simulate-pomp]{simulate}}.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{?rinit_spec}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, \link[=rprocess_spec]{see ?rprocess_spec for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{?rmeasure_spec}.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{?userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{probe} returns an object of class \sQuote{probed_pomp}, which contains the data and the model, together with the results of the \code{probe} calculation.
}
\description{
Probe a partially-observed Markov process by computing summary statistics
and the synthetic likelihood.
}
\details{
\code{probe} applies one or more \dQuote{probes} to time series data and
model simulations and compares the results.  It can be used to diagnose
goodness of fit and/or as the basis for \dQuote{probe-matching}, a
generalized method-of-moments approach to parameter estimation.

A call to \code{probe} results in the evaluation of the probe(s) in
\code{probes} on the data.  Additionally, \code{nsim} simulated data sets
are generated (via a call to \code{\link[=simulate-pomp]{simulate}}) and
the probe(s) are applied to each of these.  The results of the probe
computations on real and simulated data are stored in an object of class
\sQuote{probed_pomp}.

When \code{probe} operates on a probe-matching objective function (a \sQuote{probe_match_objfun} object), by default, the
random-number generator seed is fixed at the value given when the objective function was constructed.
Specifying \code{NULL} or an integer for \code{seed} overrides this behavior.
}
\section{Methods}{

The following methods are available.
\describe{
\item{plot}{ displays diagnostic plots.  }
\item{summary}{ displays summary information.
The summary includes quantiles (fractions of simulations with probe values less than those realized on the data) and the corresponding two-sided p-values.
In addition, the \dQuote{synthetic likelihood} (Wood 2010) is computed,
under the assumption that the probe values are multivariate-normally distributed.  }
\item{logLik}{ returns the synthetic likelihood for the probes.
NB: in general, this is not the same as the likelihood.  }
\item{as.data.frame}{
 coerces a \sQuote{probed_pomp} to a \sQuote{data.frame}.
 The latter contains the realized values of the probes on the data and on the simulations.
The variable \code{.id} indicates whether the probes are from the data or simulations.  }
}
}

\references{
\Kendall1999

\Wood2010
}
\seealso{
Other elementary POMP methods: 
\code{\link{pfilter}()},
\code{\link{pomp-package}},
\code{\link{simulate}()},
\code{\link{spect}()}

Other summary statistics methods: 
\code{\link{abc}()},
\code{\link{basic_probes}},
\code{\link{probe.match}},
\code{\link{spect}()}
}
\author{
Daniel C. Reuman, Aaron A. King
}
\concept{elementary POMP methods}
\concept{summary statistics methods}
