% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglik.R
\docType{methods}
\name{logLik}
\alias{logLik}
\alias{logLik,ANY-method}
\alias{logLik,missing-method}
\alias{logLik,listie-method}
\alias{logLik-pfilterd_pomp}
\alias{logLik,pfilterd_pomp-method}
\alias{logLik-probed_pomp}
\alias{logLik,probed_pomp-method}
\alias{logLik-kalmand_pomp}
\alias{logLik,kalmand_pomp-method}
\alias{logLik-pmcmcd_pomp}
\alias{logLik,pmcmcd_pomp-method}
\alias{logLik-bsmcd_pomp}
\alias{logLik,bsmcd_pomp-method}
\alias{logLik-objfun}
\alias{logLik,objfun-method}
\alias{logLik-spect_match_objfun}
\alias{logLik,spect_match_objfun-method}
\alias{logLik-nlf_objfun}
\alias{logLik,nlf_objfun-method}
\title{Log likelihood}
\usage{
logLik(object, ...)

\S4method{logLik}{listie}(object, ...)

\S4method{logLik}{pfilterd_pomp}(object)

\S4method{logLik}{probed_pomp}(object)

\S4method{logLik}{kalmand_pomp}(object)

\S4method{logLik}{pmcmcd_pomp}(object)

\S4method{logLik}{bsmcd_pomp}(object)

\S4method{logLik}{objfun}(object)

\S4method{logLik}{spect_match_objfun}(object)

\S4method{logLik}{nlf_objfun}(object, ...)
}
\arguments{
\item{object}{fitted model object}

\item{\dots}{ignored}
}
\value{
numerical value of the log likelihood.
Note that some methods compute not the log likelihood itself but instead a related quantity.
To keep the code simple, the \code{logLik} function is nevertheless used to extract this quantity.

When \code{object} is of \sQuote{probed_pomp} class (i.e., the result of a \code{probe} computation), \code{logLik} retrieves the \dQuote{synthetic likelihood} (see \code{\link{probe}}).

When \code{object} is of \sQuote{bsmcd_pomp} class (i.e., the result of a \code{bsmc2} computation), \code{logLik} retrieves the \dQuote{log evidence} (see \code{\link{bsmc2}}).

When \code{object} is an NLF objective function, i.e., the result of a call to \code{nlf_objfun},
\code{logLik} retrieves the \dQuote{quasi log likelihood} (see \code{\link{nlf}}).
}
\description{
Extract the estimated log likelihood (or related quantity) from a fitted model.
}
