% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_logLik.R
\docType{methods}
\name{cond.logLik}
\alias{cond.logLik}
\alias{cond.logLik,missing-method}
\alias{cond.logLik,ANY-method}
\alias{cond.logLik-kalmand_pomp}
\alias{cond.logLik,kalmand_pomp-method}
\alias{cond.logLik-pfilterd_pomp}
\alias{cond.logLik,pfilterd_pomp-method}
\alias{cond.logLik-bsmcd_pomp}
\alias{cond.logLik,bsmcd_pomp-method}
\title{Conditional log likelihood}
\usage{
\S4method{cond.logLik}{kalmand_pomp}(object, ...)

\S4method{cond.logLik}{pfilterd_pomp}(object, ...)

\S4method{cond.logLik}{bsmcd_pomp}(object, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{...}{ignored}
}
\value{
The numerical value of the conditional log likelihood.
Note that some methods compute not the log likelihood itself but instead a related quantity.
To keep the code simple, the \code{cond.logLik} function is nevertheless used to extract this quantity.

When \code{object} is of class \sQuote{bsmcd_pomp} (i.e., the result of a \code{bsmc2} computation), \code{cond.logLik} returns the conditional log \dQuote{evidence} (see \code{\link{bsmc2}}).
}
\description{
The estimated conditional log likelihood from a fitted model.
}
\details{
The conditional likelihood is defined to be the value of the density
of \deqn{Y_t | Y_1,\dots,Y_{t-1}}{Yt | Y1,\dots,Y(t-1)} evaluated at \eqn{Y_t = y^*_t}{Yt = yt*}.
Here, \eqn{Y_t}{Yt} is the observable process and \eqn{y^*_t}{yt*} is the data, at time \eqn{t}.

Thus the conditional log likelihood at time \eqn{t} is
\deqn{\ell_t(\theta) = \log f[Y_t=y^*_t \vert Y_1=y^*_1, \dots, Y_{t-1}=y^*_{t-1}],}{ell_t(theta)=log f[Yt = yt*t | Y1=y1*, \dots, Y(t-1)=y(t-1)*],}
where \eqn{f} is the probability density above.
}
\seealso{
Other particle filter methods: \code{\link{bsmc2}},
  \code{\link{eff.sample.size}}, \code{\link{filter.mean}},
  \code{\link{filter.traj}}, \code{\link{mif2}},
  \code{\link{pfilter}}, \code{\link{pmcmc}},
  \code{\link{pred.mean}}, \code{\link{pred.var}}
}
\concept{particle filter methods}
