% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy.R
\name{policy}
\alias{policy}
\title{Extract the Policy from a POMDP/MDP}
\usage{
policy(x)
}
\arguments{
\item{x}{A solved \link{POMDP} object.}
}
\value{
A list with the policy for each epoch.
}
\description{
Extracts the policy from a solved POMDP/MDP.
}
\details{
A list (one entry per epoch) with the optimal policy.
For converged, infinite-horizon problems solutions, a list with only the
converged solution is produced.
The policy is a data.frame consisting o:
\itemize{
\item Part 1: The value function with one column per state.
For POMDPs these are alpha vectors and for MDPs this is just
one column with the state.
\item Part 2: One column with the optimal action.
}
}
\examples{
data("Tiger")

# Infinite horizon
sol <- solve_POMDP(model = Tiger)
sol

# policy with value function, optimal action and transitions for observations.
policy(sol)
plot_value_function(sol)

# Finite horizon (we use incremental pruning because grid does not converge)
sol <- solve_POMDP(model = Tiger, method = "incprune", horizon = 3, discount = 1)
sol

policy(sol)
# Note: We see that it is initially better to listen till we make a decision in the final epoch. 
}
\seealso{
Other policy: 
\code{\link{optimal_action}()},
\code{\link{plot_value_function}()},
\code{\link{policy_graph}()},
\code{\link{reward}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()}
}
\author{
Michael Hahsler
}
\concept{policy}
\keyword{graphs}
