% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{visualiseHaplo}
\alias{visualiseHaplo}
\title{Visualise haplotypes in certain individuals in a certain region}
\usage{
visualiseHaplo(
  IBD_list,
  display_by = c("phenotype", "name"),
  linkage_group = NULL,
  Phenotype.df = NULL,
  genotype.ID = NULL,
  trait.ID = NULL,
  pheno_range = NULL,
  cM_range = "all",
  highlight_region = NULL,
  select_offspring = NULL,
  recombinant_scan = NULL,
  allele_fish = NULL,
  presence_threshold = 0.95,
  xlabl = TRUE,
  ylabl = TRUE,
  mainTitle = NULL,
  multiplot = NULL,
  append = FALSE,
  colPal = c("white", "navyblue", "darkred"),
  hap.wd = 0.4,
  recombination_data = NULL,
  log = NULL
)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{display_by}{Option to display a subset of the population's haplotypes either by \code{"phenotype"} or \code{"name"}.
If \code{"phenotype"} is supplied, then \code{Phenotype.df},\code{genotype.ID},\code{trait.ID} and \code{pheno_range} must also be specified.
if \code{"name"} is supplied, then \code{select_offspring} must be specified.}

\item{linkage_group}{Numeric identifier of the linkage group being examined, based on the order of \code{IBD_list}.
Only a single linkage group is allowed. If \code{IBD_list} corresponds to a single linkage group, default value
of \code{NULL} will suffice}

\item{Phenotype.df}{A data.frame containing phenotypic values, which can be used to select a subset of the population
to visualise (with extreme phenotypes for example). By default \code{NULL}, in which case a subset of the
population may be selected using the \code{select_offspring} argument.}

\item{genotype.ID}{The colname of \code{Phenotype.df} that contains the population identifiers (F1 names) (must be a colname of \code{Phenotype.df})}

\item{trait.ID}{The colname of \code{Phenotype.df} that contains the response variable to use in the model (must be a colname of \code{Phenotype.df})}

\item{pheno_range}{Vector of numeric bounds of the phenotypic scores to include (offspring selection).}

\item{cM_range}{Vector of numeric bounds of the genetic region to be explored. If none are specified, the default of \code{"all"} means all cM positions will be included.}

\item{highlight_region}{Option to hightlight a particular genetic region on the plot; can be a single position or a vector of 2 positions. By default \code{NULL}.}

\item{select_offspring}{Vector of offspring identifiers to visualise, must be supplied if \code{display_by} = \code{"name"}. Specifying \code{"all"} will result in
all offspring haplotypes being visualised.}

\item{recombinant_scan}{Vector of homologue numbers between which to search for recombinant offspring in the visualised region and selected individuals.
By default \code{NULL}, in which case no search is preformed.}

\item{allele_fish}{Vector of homologue numbers of interest, for which to search for offspring that carry these homologues (in the visualised
region). By default \code{NULL}, in which case no search ("fishing") is performed.}

\item{presence_threshold}{Numeric. The minimum probability used to declare presence of a homologue in an individual. This is only needed if a \code{recombinant_scan} is
performed. By default a value of 0.95 is used. When searching for recombinants, this value is also used to denote the proportion of loci carrying the required number
of homologues (i.e. by default 95 per cent of loci should have between 0.95 and 1.1 copies of the specified recombinant homologues).}

\item{xlabl}{Logical, by default \code{TRUE}. Should an x-axis label be used?}

\item{ylabl}{Logical, by default \code{TRUE}. Should a y-axis label be used?}

\item{mainTitle}{Option to override default plot titles with a (vector of) captions. By default \code{NULL}.}

\item{multiplot}{Vector of integers. By default \code{NULL} so haplotypes are plotted singly;
otherwise a vector specifying the number of rows and columns in the plot layout.}

\item{append}{Option to allow user to append new plots to spaces generated by \code{multiplot}, otherwise these are
filled with blank plots. By default \code{FALSE}. If \code{TRUE}, then a large enough \code{multiplot} grid should be
generated to make this option meaningful.}

\item{colPal}{Colour palette to use in the visualisation (best to provide 3 colours).}

\item{hap.wd}{The width of the haplotype tracks to be plotted, generally recommended to be about 0.4 (default value)}

\item{recombination_data}{List object as returned by the function \code{count_recombinations}. By default \code{NULL}, 
in which case no overlay of predicted recombination events is performed. However, it can be useful
to visualise predicted recombination events, particularly as this might help inform the choice of argument \code{plausible_pairing_prob}
of that function. See \code{\link{count_recombinations}} for more details.}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}
}
\value{
If \code{recombinant_scan} vector is supplied, a vector of recombinant offspring ID in the region of interest (otherwise \code{NULL}).
}
\description{
Function to visualise the haplotypes of a certain region in certain individuals
}
\examples{
data("IBD_4x")
visualiseHaplo(IBD_list = IBD_4x,
               display_by = "name",
               linkage_group = 1,
               select_offspring = "all",
               multiplot = c(3,3))
}
