% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{QTLscan}
\alias{QTLscan}
\title{General QTL function that allows for co-factors, completely randomised block designs and the possibility to derive LOD thresholds using a permutation test}
\usage{
QTLscan(
  IBD_list,
  Phenotype.df,
  genotype.ID,
  trait.ID,
  block = NULL,
  folder = NULL,
  filename.short,
  cofactor_df = NULL,
  prop_Pheno_rep = 0.5,
  perm_test = FALSE,
  N_perm.max = 1000,
  alpha = 0.05,
  gamma = 0.05,
  ncores = 1,
  log = NULL,
  ...
)
}
\arguments{
\item{IBD_list}{List of IBD probabilities}

\item{Phenotype.df}{A data.frame containing phenotypic values}

\item{genotype.ID}{The colname of \code{Phenotype.df} that contains the offspring identifiers (F1 names)}

\item{trait.ID}{The colname of \code{Phenotype.df} that contains the response variable to use in the model}

\item{block}{The blocking factor to be used, if any (must be colname of \code{Phenotype.df}). By default \code{NULL}, in which case no blocking structure (for unreplicated experiments)}

\item{folder}{If markers are to be used as co-factors, the path to the folder in which the imported IBD probabilities is contained can be provided here. By default this is \code{NULL}, if files are in working directory.}

\item{filename.short}{If TetraOrigin was used and co-factors are being included, the shortened stem of the filename of the \code{.csv} files containing the output of TetraOrigin, i.e. without the tail "_LinkageGroupX_Summary.csv" which is added by default to all output of TetraOrigin.}

\item{cofactor_df}{A 3-column data frame of co-factor(s); column 1 gives linkage group identifiers, column 2 specifies the co-factor type, i.e. whether the co-factor is a "marker" or "position",
and column 3 gives the marker/position IDs of the co-factors. By default \code{NULL}, in which case no co-factors are included in the analysis.}

\item{prop_Pheno_rep}{The minimum proportion of phenotypes represented across blocks. If less than this, the individual is removed from the analysis. If there is incomplete
data, the missing phenotypes are imputed using the mean values across the recorded observations.}

\item{perm_test}{Logical, by default \code{FALSE}. If \code{TRUE}, a permutation test will be performed to determine a
genome-wide significance threshold.}

\item{N_perm.max}{The maximum number of permutations to run if \code{perm_test} is \code{TRUE}; by default this is 1000.}

\item{alpha}{The P-value to be used in the selection of a threshold if \code{perm_test} is \code{TRUE}, by default 0.05 (i.e. the 0.95 quantile).}

\item{gamma}{The width of the confidence intervals used around the permutation test threshold using the approach of Nettleton & Doerge (2000), by default 0.05.}

\item{ncores}{Number of cores to use if parallel computing is required. Works both for Windows and UNIX (using \code{doParallel}).
Use \code{parallel::detectCores()} to find out how many cores you have available.}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}

\item{\dots}{Arguments passed to \code{\link{plot}}}
}
\value{
A nested list; each list element (per linkage group) contains the following items:
\itemize{
\item{QTL.res : }{Single matrix of QTL results with columns chromosome, position, LOD and expl.var (rate of variance explained at each position).}
\item{Perm.res : }{If \code{perm_test} = \code{FALSE}, this will be \code{NULL}.
Otherwise, Perm.res contains a list of the results of the permutation test, with list items
"quantile","threshold" and "scores". Quantile refers to which quantile of scores was used to determine the threshold.
Note that scores are each of the maximal LOD scores across the entire genome scan per permutation, thus returning a
genome-wide threshold rather than a chromosome-specific threshold. If the latter is preferred, restricting the
\code{IBD_list} to a single chromosome and re-running the permutation test will provide the desired threshold.}
\item{Residuals : }{If a blocking factor or co-factors are used, this is the (named) vector of residuals used as input for the
QTL scan. Otherwise, this is the set of (raw) phenotypes used in the QTL scan.}
\item{Map : }{Original map of genetic marker positions upon which the IBDs were based, most often used
for adding rug of marker positions to QTL plots.}
\item{LG_names : }{Names of the linkage groups}
}
}
\description{
Function to run QTL analysis using IBD probabilties given (possibly replicated) phenotypes, assuming randomised experimental design
}
\examples{
data("IBD_4x","Phenotypes_4x")
qtl_LODs.4x <- QTLscan(IBD_list = IBD_4x,
                       Phenotype.df = Phenotypes_4x,
                       genotype.ID = "geno",
                       trait.ID = "pheno",
                       block = "year")
}
