% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{comp_ind_dj}
\alias{comp_ind_dj}
\title{Index of spheres on a polysphere}
\usage{
comp_ind_dj(d)
}
\arguments{
\item{d}{vector of size \code{r} with dimensions.}
}
\value{
A vector of size \code{sum(d) + 1}.
}
\description{
Given Cartesian coordinates of polyspherical data, computes
the \code{0}-based indexes at which the Cartesian coordinates for each
sphere start and end.
}
\examples{
# Example on (S^1)^3
d <- c(1, 1, 1)
comp_ind_dj(d = d)
comp_ind_dj(d = d) + 1

# Example on S^1 x S^2
d <- c(1, 2)
comp_ind_dj(d = d)
comp_ind_dj(d = d) + 1
}
