\name{constrppprob}
\alias{constrppprob}
\keyword{survey}
\concept{Bayesian survey sampling}
\concept{Polya posterior}
\title{Dependent Sampling from the Uniform Distribution on a Polytope.}
\description{Let \eqn{p=(p_1,\ldots,p_n)}{p=(p1,...,pn)}
  be a probability distribution
  which belongs to a lower dimensional polytope of the \eqn{n}-dimensional
  simplex.  The polytope is defined by a collection of linear
  equality and inequality constraints.  A dependent sequence of the 
  \eqn{p}'s are generated by a Markov chain using the Metropolis-Hastings
  algorithm whose stationary distribution is the uniform distribution
  over the polytope.  This is done by generating \eqn{k} blocks
  of size \code{step}
  where the last member of each is returned.}
\usage{constrppprob(A1,A2,A3,b1,b2,b3,initsol,step,k)}
\arguments{
  \item{A1}{The matrix for the equality constraints.This must always
  contain the constraint \code{sum(p) == 1}.}
\item{A2}{The matrix for the \code{<=} inequality constraints.  This must always
  contain the constraints \code{-p <= 0}.}
\item{A3}{The matrix for the \code{>=} inequality constraints.  If there are no
  such constraints \code{A3} must be set equal to \code{NULL}.}
\item{b1}{The rhs vector for \code{A1}, each component must be nonnegative.}
\item{b2}{The rhs vector for \code{A2}, each component must be nonnegative.}
\item{b3}{The rhs vector for \code{A3}, each component must be nonnegative.
  If \code{A3} is \code{NULL} then \code{b3} must be NULL.}
\item{initsol}{A vector which lies in the interior of the polytope.}
\item{step}{The number of \code{p}'s generated in a block before the
  last member of a block is returned.}
\item{k}{The total number of blocks generated and hence the number
  of \code{p}'s returned.}
}
\value{The returned value is a \eqn{k} by \eqn{n} matrix of probability vectors.
}
\examples{
A1<-rbind(rep(1,6),1:6)
A2<-rbind(c(2,5,7,1,10,8),diag(-1,6))
A3<-matrix(c(1,1,1,0,0,0),1,6)
b1<-c(1,3.5)
b2<-c(6,rep(0,6))
b3<-0.45
initsol<-rep(1/6,6)
constrppprob(A1,A2,A3,b1,b2,b3,initsol,2000,5)
}
