% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdd.R
\name{gdd}
\alias{gdd}
\title{Growing Degree Days Function}
\usage{
gdd(tmax, tmin, tbase, tbase_max, type = "C")
}
\arguments{
\item{tmax}{daily maximum temperature}

\item{tmin}{daily minimum temperature}

\item{tbase}{base temperature}

\item{tbase_max}{maximum base temperature}

\item{type}{either "B", "C", or "D". The default is "C". Type "B" - The heat units are calculated based on the difference between the mean daily temperature and the threshold (`tbase`). In the case when the value of `tmin` is lower than `tbase`, then it is replaced by `tbase`. Type `"C"` - same as type `"B"` and when the value of `tmax` is larger than `tbase_max`, then it is replaced by `tbase_max`. Type `"D"`- same as type `"B"` and when the value of `tmax` is larger than `tbase_max`, then no heat units are added.}
}
\value{
a numeric vector with GDD values
}
\description{
This function calculates growing degree days (GDD) using the average of the daily maximum
and minimum temperatures, a base temperature and a maximum base temperature
}
\examples{
set.seed(25)
df <- data.frame(tmax = runif(100, 6, 10), tmin = runif(100, 4, 6))

gdd(tmax = df$tmax, tmin = df$tmin, tbase = 5, tbase_max = 30)


}
\references{
Baskerville, G., & Emin, P. (1969). Rapid Estimation of Heat Accumulation from Maximum and Minimum Temperatures. Ecology, 50(3), 514-517. doi:10.2307/1933912
}
