% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers_replacer.R
\name{outliers_replacer}
\alias{outliers_replacer}
\title{A Outliers Replacer Function}
\usage{
outliers_replacer(x, value, date, threshold = 5, ...)
}
\arguments{
\item{x}{A data.frame with dates and pollen count values}

\item{value}{The name of the column with pollen count values}

\item{date}{The name of the dates column}

\item{threshold}{A number indicating how many times outling value needs to be larger than the backgroud to be replaces (default is 5)}

\item{...}{Other arguments, such as `sum_percent`}
}
\value{
A new data.frame object with replaced outliers
}
\description{
This function finds outliers in pollen time-series and replace them with backgroud values
}
\examples{

data(pollen_count)
df <- subset(pollen_count, site=='Shire')
new_df <- outliers_replacer(df, value="birch", date="date")
identical(df, new_df)

library('purrr')
new_pollen_count <- pollen_count \%>\% split(., .$site) \%>\% 
                 map_df(~outliers_replacer(., value="hazel", date="date", threshold=4))
    
}
\references{
Kasprzyk, I. and A. Walanus.: 2014. Gamma, Gaussian and Logistic Distribution Models for Airborne Pollen Grains and Fungal Spore Season Dynamics, Aerobiologia 30(4), 369-83.
}
\keyword{outliers}
\keyword{pollen}
\keyword{pollen,}
