% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_def.R
\name{policy_def}
\alias{policy_def}
\title{Define Policy}
\usage{
policy_def(policy_functions, full_history = FALSE, reuse = FALSE, name = NULL)
}
\arguments{
\item{policy_functions}{A single function/character string or a list of
functions/character strings. The list must have the same length as the number
of stages.}

\item{full_history}{If TRUE, the full history at each stage is used as
input to the policy functions.}

\item{reuse}{If TRUE, the policy function is reused at every stage.}

\item{name}{Character string.}
}
\value{
Function of class \code{"policy"}. The function takes a
\link{policy_data} object as input and returns a \link{data.table}
with keys \code{id} and \code{stage} and action variable \code{d}.
}
\description{
\code{policy_def} returns a function of class \link{policy}.
The function input is a \link{policy_data} object and it returns a \link{data.table}
with keys \code{id} and \code{stage} and action variable \code{d}.
}
\examples{
library("polle")
### Single stage"
d1 <- sim_single_stage(5e2, seed=1)
pd1 <- policy_data(d1, action="A", covariates=list("Z", "B", "L"), utility="U")
pd1

# defining a static policy (A=1):
p1_static <- policy_def(1)

# applying the policy:
p1_static(pd1)

# defining a dynamic policy:
p1_dynamic <- policy_def(
  function(Z, L) ((3*Z + 1*L -2.5)>0)*1
)
p1_dynamic(pd1)

### Two stages:
d2 <- sim_two_stage(5e2, seed = 1)
pd2 <- policy_data(d2,
                  action = c("A_1", "A_2"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))

# defining a static policy (A=0):
p2_static <- policy_def(0,
                        reuse = TRUE)
p2_static(pd2)

# defining a reused dynamic policy:
p2_dynamic_reuse <- policy_def(
  function(L) (L > 0)*1,
  reuse = TRUE
)
p2_dynamic_reuse(pd2)

# defining a dynamic policy for each stage based on the full history:
# available variable names at each stage:
get_history_names(pd2, stage = 1)
get_history_names(pd2, stage = 2)

p2_dynamic <- policy_def(
  policy_functions = list(
    function(L_1) (L_1 > 0)*1,
    function(L_1, L_2) (L_1 + L_2 > 0)*1
  ),
  full_history = TRUE
)
p2_dynamic(pd2)
}
\seealso{
\code{\link[=get_history_names]{get_history_names()}}, \code{\link[=get_history]{get_history()}}.
}
