% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{tt_time_slice}
\alias{tt_time_slice}
\title{Table Transformer: slice a table with a slice point on a time column}
\usage{
tt_time_slice(
  tbl,
  time_column = NULL,
  slice_point = 0,
  keep = c("left", "right"),
  arrange = FALSE
)
}
\arguments{
\item{tbl}{A table object to be used as input for the transformation. This
can be a data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.}

\item{time_column}{The time-based column that will be used as a basis for the
slicing. If no time column is provided then the first one found will be
used.}

\item{slice_point}{The location on the \code{time_column} where the slicing will
occur. This can either be a decimal value from \code{0} to \code{1}, an ISO 8601
formatted time string (as a date or a date-time), a \code{POSIXct} time, or a
\code{Date} object.}

\item{keep}{Which slice should be kept? The \code{"left"} side (the default)
contains data rows that are earlier than the \code{slice_point} and the
\code{"right"} side will have rows that are later.}

\item{arrange}{Should the slice be arranged by the \code{time_column}? This may be
useful if the input \code{tbl} isn't ordered by the \code{time_column}. By default,
this is \code{FALSE} and the original ordering is retained.}
}
\value{
A data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object
depending on what was provided as \code{tbl}.
}
\description{
With any table object containing date, date-time columns, or a mixture
thereof, any one of those columns can be used to effectively slice the data
table in two with a \code{slice_point}: and you get to choose which of those
slices you want to keep. The slice point can be defined in several ways. One
method involves using a decimal value between \code{0} and \code{1}, which defines the
slice point as the time instant somewhere between the earliest time value (at
\code{0}) and the latest time value (at \code{1}). Another way of defining the slice
point is by supplying a time value, and the following input types are
accepted: (1) an ISO 8601 formatted time string (as a date or a date-time),
(2) a \code{POSIXct} time, or (3) a \code{Date} object.
}
\details{
There is the option to \code{arrange} the table by the date or date-time values in
the \code{time_column}. This ordering is always done in an ascending manner. Any
\code{NA}/\code{NULL} values in the \code{time_column} will result in the corresponding rows
can being removed (no matter which slice is retained).
}
\section{Function ID}{

12-6
}

\examples{
# With the `game_revenue` dataset,
# which has entries in the first
# 21 days of 2015, elect to get all
# of the records where the `time`
# values are strictly for the first
# 15 days of 2015
tt_time_slice(
  tbl = game_revenue,
  time_column = "time",
  slice_point = "2015-01-16"
)

# Omit the first 25\% of records
# from `small_table` on the basis
# of a timeline that begins at 
# `2016-01-04 11:00:00` and
# ends at `2016-01-30 11:23:00`
small_table \%>\%
  tt_time_slice(
    slice_point = 0.25,
    keep = "right"
  )

}
\seealso{
Other Table Transformers: 
\code{\link{get_tt_param}()},
\code{\link{tt_string_info}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_tbl_colnames}()},
\code{\link{tt_tbl_dims}()},
\code{\link{tt_time_shift}()}
}
\concept{Table Transformers}
