% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_transformers.R
\name{tt_tbl_dims}
\alias{tt_tbl_dims}
\title{Table Transformer: get the dimensions of a table}
\usage{
tt_tbl_dims(tbl)
}
\arguments{
\item{tbl}{A table object to be used as input for the transformation. This
can be a data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.}
}
\value{
A \code{tibble} object.
}
\description{
With any table object, you can produce an information table that contains
nothing more than the table's dimensions: the number of rows and the number
of columns.

The table produced will have two columns and two rows. The first is the
\code{"dim"} column with the labels \code{"rows"} and \code{"columns"}; the second column,
\code{"value"}, contains the row and column counts.
}
\section{Function ID}{

12-3
}

\examples{
# Get the dimensions of the
# `game_revenue` dataset that's
# included in the package
tt_tbl_dims(game_revenue)

# This output table is useful when
# you want to validate the
# dimensions of the table; here,
# we check that `game_revenue` has
# at least 1500 rows
tt_tbl_dims(game_revenue) \%>\%
  col_vals_gt(
    columns = vars(value),
    value = 1500,
    segments = dim ~ "rows"
  )

# We can check `small_table` for
# an exact number of columns (`8`)
tt_tbl_dims(small_table) \%>\%
  dplyr::filter(dim == "columns") \%>\%
  col_vals_equal(
    columns = vars(value),
    value = 8
  )

}
\seealso{
Other Table Transformers: 
\code{\link{tt_string_info}()},
\code{\link{tt_summary_stats}()},
\code{\link{tt_time_shift}()},
\code{\link{tt_time_slice}()}
}
\concept{Table Transformers}
