% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_ops.R
\name{remove_tbl}
\alias{remove_tbl}
\title{Remove a data table associated with an \emph{agent} or \emph{informant}}
\usage{
remove_tbl(x)
}
\arguments{
\item{x}{An \emph{agent} object of class \code{ptblank_agent}, or, an \emph{informant} of
class \code{ptblank_informant}.}
}
\description{
Removing an \emph{agent} or \emph{informant}'s association to a data table can be done
with the \code{remove_tbl()} function. This can be useful to ensure that the table
data isn't unintentionally written to disk. It is usually best to avoid
directly associating a table to an \emph{agent} or \emph{informant}, instead opting for
setting a table-reading function (via \code{\link[=create_agent]{create_agent()}} and
\code{\link[=create_informant]{create_informant()}}'s \code{read_fn} argument, or, with \code{\link[=set_read_fn]{set_read_fn()}}). The
association to a table can be set again with \code{\link[=set_tbl]{set_tbl()}}.
}
\section{Function ID}{

8-4
}

\seealso{
Other Object Ops: 
\code{\link{remove_read_fn}()},
\code{\link{set_read_fn}()},
\code{\link{set_tbl}()},
\code{\link{x_read_disk}()},
\code{\link{x_write_disk}()}
}
\concept{Object Ops}
