% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.rpart.R
\name{pmml.rpart}
\alias{pmml.rpart}
\title{Generate the PMML representation for an rpart object from the package \pkg{rpart}.}
\usage{
\method{pmml}{rpart}(
  model,
  model_name = "RPart_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "RPart Decision Tree Model",
  copyright = NULL,
  model_version = NULL,
  transforms = NULL,
  missing_value_replacement = NULL,
  dataset = NULL,
  ...
)
}
\arguments{
\item{model}{An rpart object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{model_version}{A string specifying the model version.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{dataset}{Data used to train the rpart model.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the rpart object.
}
\description{
Generate the PMML representation for an rpart object from the package \pkg{rpart}.
}
\details{
Supports regression tree as well as classification. The object is
represented in the PMML TreeModel format.
}
\examples{
library(rpart)

fit <- rpart(Species ~ ., data = iris)

fit_pmml <- pmml(fit)
}
\references{
\href{https://CRAN.R-project.org/package=rpart}{rpart: Recursive
Partitioning (on CRAN)}
}
\author{
Graham Williams
}
