% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.kmeans.R
\name{pmml.kmeans}
\alias{pmml.kmeans}
\title{Generate the PMML representation for a kmeans object from
the package \pkg{stats}.}
\usage{
\method{pmml}{kmeans}(model, model_name = "KMeans_Model",
  app_name = "SoftwareAG PMML Generator",
  description = "KMeans cluster model", copyright = NULL,
  transforms = NULL, missing_value_replacement = NULL,
  algorithm.name = "KMeans: Hartigan and Wong", ...)
}
\arguments{
\item{model}{A kmeans object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{algorithm.name}{The variety of kmeans used.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
The kmeans object (a cluster described by k centroids) is
converted into a PMML representation.
}
\details{
A kmeans object is obtained by applying the \code{kmeans} function from the
\code{stats} package. This method typically requires the user to normalize
all the variables; these operations can be done using transforms so that the
normalization information is included in PMML.
}
\examples{

ds <- rbind(
  matrix(rnorm(100, sd = 0.3), ncol = 2),
  matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2)
)
colnames(ds) <- c("Dimension1", "Dimension2")
cl <- kmeans(ds, 2)
pmml(cl)

}
\references{
\href{http://stat.ethz.ch/R-manual/R-devel/library/stats/html/kmeans.html}{R
project: K-Means Clustering}
}
\author{
Graham Williams
}
