\name{.0.readme}
\alias{readme}
\alias{CHECK}
\alias{CLASS.worker}
\alias{COMM.RANK}
\alias{COMM.SIZE}
\alias{SAVE.param}
\alias{SAVE.iter}
\alias{U.worker}
\alias{W.worker}
\alias{W.worker.rowSums}
\alias{Z.colSums}
\alias{Z.worker}
\alias{p.times.logtwopi}
\title{Read me first function}
\description{
  This function print the annotations of all variables used in this package.
}
\usage{
  readme()
}
\details{
  This package is optimized in the way by pre-specifying several global
  variables. These variables will be overwrote by EM algorithms. Users should
  use these names to access the results and utilize them with cautions.
}
\value{
  A readme message will print on screen by default and explain the global
  variables used in this package, including:
\tabular{ll}{\code{CHECK}            \tab convergent checking \cr
             \code{CLASS.worker}     \tab true id of each data, a vector of
                                          length N.worker and has values
                                          from 1 to K \cr
             \code{COMM.RANK}        \tab rank of current processor, obtained
                                          from
                                          \code{\link[Rmpi]{mpi.comm.rank}}\cr
             \code{COMM.SIZE}        \tab total processors in MPI world,
                                          obtained from
                                          \code{\link[Rmpi]{mpi.comm.size}}\cr
             \code{\link{CONTROL}}  \tab controls for EM iterations \cr
             \code{\link{PARAM}}     \tab set or parameters \cr
             \code{SAVE.param}       \tab (debug only)
                                          save parameters for every
                                          iterations \cr
             \code{SAVE.iter}        \tab (debug only)
                                          save computing time for every
                                          iterations \cr
             \code{U.worker}         \tab temporary storage for density \cr
             \code{W.worker}         \tab temporary storage for
                                          \code{eta * density} \cr
             \code{W.worker.rowSums} \tab temporary storage for rowSums
                                          of \code{W.worker} \cr
             \code{\link{X.worker}}  \tab generated data set with dimension
                                          with dimension
                                          \code{N.worker * p} \cr
             \code{Z.colSums}        \tab temporary storage for rowSums
                                          of \code{Z.worker} \cr
             \code{Z.worker}         \tab posterior probabilities \cr
             \code{p.times.logtwopi} \tab \code{p * log(2 * pi)}
}
  Each variable may contain several elements if it is a list, some variables
  are used for temporary storages in order to optimize computing, and some
  variables are used for constant variables. These variables may be restricted,
  and only generated by the function \code{\link{set.global}}.
}
\references{
  High Performance Statistical Computing Website:
  \url{http://thirteen-01.stat.iastate.edu/snoweye/hpsc/}
}
\author{
  Wei-Chen Chen \email{wccsnow@gmail.com} and George Ostrouchov.
}
\seealso{
  \code{\link{set.global}},
  \code{\link{printmpi}}.
}
\examples{
\dontrun{
readme()
}
}
\keyword{global variables}

