% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cases.R
\name{test_pattern_}
\alias{test_pattern_}
\alias{test_pattern}
\title{Test if a pattern matches an expression}
\usage{
test_pattern_(expr, test_expr, eval_env = rlang::caller_env(),
  match_parent_env = rlang::caller_env())

test_pattern(expr, test_expr, eval_env = rlang::caller_env(),
  match_parent_env = rlang::caller_env())
}
\arguments{
\item{expr}{A value created using constructors.}

\item{test_expr}{A constructor pattern to test \code{expr} against.}

\item{eval_env}{The environment where constructors can be found.}

\item{match_parent_env}{Environment to use as the parent of the match
bindings we return. This parameter enables you provide additional values to
the environment where match-expressions are evaluated.}
}
\value{
\code{NULL} if the pattern does not match or an environment with
bound variables if it does.
}
\description{
Test if a value, \code{expr}, created from constructors matches a pattern of
constructors. The \code{test_pattern_} function requires that
\code{test_expr} is a quoted expression while the \code{test_pattern}
function expects a bare expression and will quote it itself.
}
\section{Functions}{
\itemize{
\item \code{test_pattern_}: Version that quotes \code{test_expr} itself.

\item \code{test_pattern}: Version that quotes \code{test_expr} itself.
}}

\examples{
type := ZERO | ONE(x) | TWO(x,y)
zero <- ZERO
one <- ONE(1)
two <- TWO(1,2)

as.list(test_pattern(zero, ZERO)) # returns an empty binding
test_pattern_(one, quote(ZERO)) # returns NULL
as.list(test_pattern_(one, quote(ONE(v)))) # returns a binding for v
as.list(test_pattern(two, TWO(v,w))) # returns a binding for v and w

}
