% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fns.R
\name{plot.cvFilt}
\alias{plot.cvFilt}
\title{Plot cvFilt Object}
\usage{
\method{plot}{cvFilt}(
  x,
  cv_threshold = NULL,
  interactive = FALSE,
  x_lab = NULL,
  y_lab = NULL,
  x_lab_size = 11,
  y_lab_size = 11,
  x_lab_angle = 0,
  title_lab = NULL,
  title_lab_size = 14,
  legend_lab = NULL,
  legend_position = "right",
  log_scale = TRUE,
  n_breaks = 15,
  n_bins = 30,
  bw_theme = TRUE,
  palette = NULL,
  ...
)
}
\arguments{
\item{x}{object of class cvFilt generated via
\code{\link{cv_filter}}}

\item{cv_threshold}{numeric value for cv threshold above which to remove the
corresponding biomolecules}

\item{interactive}{logical value. If TRUE produces an interactive plot.}

\item{x_lab}{character string specifying the x-axis label.}

\item{y_lab}{character string specifying the y-axis label. The default is
NULL in which case the y-axis label will be the metric selected for the
\code{metric} argument.}

\item{x_lab_size}{integer value indicating the font size for the x-axis.
The default is 11.}

\item{y_lab_size}{integer value indicating the font size for the y-axis.
The default is 11.}

\item{x_lab_angle}{integer value indicating the angle of x-axis labels.
The default is 0.}

\item{title_lab}{character string specifying the plot title}

\item{title_lab_size}{integer value indicating the font size of the plot
title. The default is 14.}

\item{legend_lab}{character string specifying the legend title}

\item{legend_position}{character string specifying the position of the
legend. Can be one of "right", "left", "top", "bottom", or "none". The
default is "none".}

\item{log_scale}{logical value. Indicates whether to use a log2 transformed x-axis.
The default is TRUE.}

\item{n_breaks}{integer value specifying the number of breaks to use. You
may get less breaks if rounding causes certain values to become non-unique.
The default is 15.}

\item{n_bins}{integer value specifying the number of bins to draw in the
histogram.  The default is 30.}

\item{bw_theme}{logical value. If TRUE uses the ggplot2 black and white theme.}

\item{palette}{character string indicating the name of the RColorBrewer
palette to use. For a list of available options see the details section in
\code{\link[RColorBrewer]{RColorBrewer}}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
ggplot2 plot object if interactive is FALSE, or plotly plot object if
  interactive is TRUE
}
\description{
For plotting an S3 object of type 'cvFilt'
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
data(pep_object)
mypep <- group_designation(
  omicsData = pep_object,
  main_effects = "Phenotype"
)

cvfilt <- cv_filter(omicsData = mypep)

plot(cvfilt, cv_threshold = 20)
plot(cvfilt, cv_threshold = 10, log_scale = FALSE)
\dontshow{\}) # examplesIf}
}
