% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{total_count_filter}
\alias{total_count_filter}
\title{Total Count Filter Object}
\usage{
total_count_filter(omicsData)
}
\arguments{
\item{omicsData}{an object of the class 'seqData', created by
\code{\link{as.seqData}}}
}
\value{
An S3 object of class 'totalcountFilt' (data.frame) that contains the
  molecule identifier and the total count of observed reads for that molecule
  across all samples.
}
\description{
This function returns a totalcountFilt object for use with
\code{\link{applyFilt}}
}
\details{
Filter is based off of recommendations in edgeR processing, where
the low-observed biomolecules are removed from processing. Default
recommendation in edgeR is at least 15 total counts observed across samples
(i.e., if the sum of counts in a row of e_data is < 15, default edgeR
filtering would remove this biomolecule).
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)
to_filter <- total_count_filter(omicsData = rnaseq_object)
summary(to_filter, min_count = 15)
}
\dontshow{\}) # examplesIf}
}
\references{
Chen Y, Lun ATL, and Smyth, GK (2016). From reads to genes to pathways:
differential expression analysis of RNA-Seq experiments using Rsubread and
the edgeR quasi-likelihood pipeline. F1000Research 5, 1438.
http://f1000research.com/articles/5-1438
}
\author{
Rachel Richardson
}
