% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\name{register_async}
\alias{register_async}
\alias{show_registered_async}
\alias{get_async}
\title{Register an async evaluator}
\usage{
register_async(name, fun, dependency = NULL)

show_registered_async()

get_async(name = NULL, ...)
}
\arguments{
\item{name}{The name of the evaluator}

\item{fun}{A function that, upon calling it returns an evaluator taking an
\code{expr} and \code{envir} argument. See the \link[=async_evaluators]{async evaluator}
functions for examples}

\item{dependency}{Package dependencies for the evaluator.}

\item{...}{Arguments passed on to the async function creator}
}
\description{
plumber supports async request handling in two ways. Either manual by
returning a promise from the handler, or automatic through the \verb{@async} tag /
\code{async} argument in \link[=api_request_handlers]{the handler functions}. The
default evaluator is controlled by the \code{plumber2.async} option or the
\code{PLUMBER2_ASYNC} environment variable.
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Register an async evaluator based on future (the provided mirai backend is
# superior in every way so this is for illustrative purpose)
future_async <- function(...) {
  function(expr, envir) {
    promises::future_promise(
      expr = expr,
      envir = envir,
      substitute = FALSE,
      ...
    )
  }
}
register_async("future", future_async, c("promises", "future"))
\dontshow{\}) # examplesIf}
}
