% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T2.R
\name{T2_pls}
\alias{T2_pls}
\title{Hotelling's T^2 based variable selection in PLS -- T^2-PLS)}
\usage{
T2_pls(ytr, Xtr, yts, Xts, ncomp = 10, alpha = c(0.2, 0.15, 0.1, 0.05, 0.01))
}
\arguments{
\item{ytr}{Vector of responses for model training.}

\item{Xtr}{Matrix of predictors for model training.}

\item{yts}{Vector of responses for model testing.}

\item{Xts}{Matrix of predictors for model testing.}

\item{ncomp}{Number of PLS components.}

\item{alpha}{Hotelling's T^2 significance levels.}
}
\value{
Parameters and variables corresponding to variable selections
of minimum error and minimum variable set.
}
\description{
Variable selection based on the T^2 statistic. A side effect
of running the selection is printing of tables and production of plots,
as the T^2 calculations done by \code{\link[MSQC]{mult.chart}}.
}
\examples{
data(gasoline, package = "pls")
library(pls)
if(interactive()){
  t2 <- T2_pls(gasoline$octane[1:40], gasoline$NIR[1:40,], 
             gasoline$octane[-(1:40)], gasoline$NIR[-(1:40),], 
             ncomp = 10, alpha = c(0.2, 0.15, 0.1, 0.05, 0.01))
  matplot(t(gasoline$NIR), type = 'l', col=1, ylab='intensity')
  points(t2$mv[[1]], colMeans(gasoline$NIR)[t2$mv[[1]]], col=2, pch='x')
  points(t2$mv[[2]], colMeans(gasoline$NIR)[t2$mv[[2]]], col=3, pch='o')
}
}
