% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVE.R
\name{bve_pls}
\alias{bve_pls}
\title{Backward variable elimination PLS (BVE-PLS)}
\usage{
bve_pls(y, X, ncomp = 10, ratio = 0.75, VIP.threshold = 1)
}
\arguments{
\item{y}{vector of response values (\code{numeric} or \code{factor}).}

\item{X}{numeric predictor \code{matrix}.}

\item{ncomp}{integer number of components (default = 10).}

\item{ratio}{the proportion of the samples to use for calibration (default = 0.75).}

\item{VIP.threshold}{thresholding to remove non-important variables (default = 1).}
}
\value{
Returns a vector of variable numbers corresponding to the model 
having lowest prediction error.
}
\description{
A backward variable elimination procedurewas for elimination
of non informative variables.
}
\details{
Variables are first sorted with respect to some importancemeasure, 
and usually one of the filter measures described above are used. Secondly, a 
threshold is used to eliminate a subset of the least informative variables. Then
a model is fitted again to the remaining variables and performance is measured. 
The procedure is repeated until maximum model performance is achieved.
}
\examples{
data(gasoline, package = "pls")
with( gasoline, bve_pls(octane, NIR) )

}
\author{
Tahir Mehmood, Kristian Hovde Liland, Solve Sæbø.
}
\references{
I. Frank, Intermediate least squares regression method, Chemometrics and
Intelligent Laboratory Systems 1 (3) (1987) 233-242.
}
\seealso{
\code{\link{VIP}} (SR/sMC/LW/RC), \code{\link{filterPLSR}}, \code{\link{spa_pls}}, 
\code{\link{stpls}}, \code{\link{truncation}}, \code{\link{bve_pls}}, \code{\link{mcuve_pls}},
\code{\link{ipw_pls}}, \code{\link{ga_pls}}, \code{\link{rep_pls}}.
}

