% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.plsRbetamodel.R
\name{summary.plsRbetamodel}
\alias{summary.plsRbetamodel}
\title{Summary method for plsRbeta models}
\usage{
\method{summary}{plsRbetamodel}(object, ...)
}
\arguments{
\item{object}{an object of the class \code{"plsRbetamodel"}}

\item{\dots}{further arguments to be passed to or from methods.}
}
\value{
\item{call }{function call of plsR beta models}
}
\description{
This function provides a summary method for the class \code{"plsRbetamodel"}
}
\examples{

data("GasolineYield",package="betareg")
modpls <- plsRbeta(yield~.,data=GasolineYield,nt=3,modele="pls-beta")
summary(modpls)

}
\references{
Frédéric Bertrand, Nicolas Meyer,
Michèle Beau-Faller, Karim El Bayed, Izzie-Jacques Namer,
Myriam Maumy-Bertrand (2013). Régression Bêta
PLS. \emph{Journal de la Société Française de Statistique},
\bold{154}(3):143-159.
\url{https://ojs-test.apps.ocp.math.cnrs.fr/index.php/J-SFdS/article/view/215}
}
\seealso{
\code{\link{summary}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{methods}
\keyword{print}
