% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABCxy.R
\name{ABCxy}
\alias{ABCxy}
\title{Symmetrical Transformation}
\usage{
ABCxy(
  x,
  A,
  B,
  C,
  p1 = NULL,
  p2 = NULL,
  f = NULL,
  group = TRUE,
  todf = TRUE,
  checks = TRUE
)
}
\arguments{
\item{x}{the input. It can be a data frame, matrix, tibble object, 
or a list of 
these kinds of objects. Each object must have exactly 2 columns 
and must be numeric without NA.
If it has more than 2 columns, only the first 2 columns 
will be used.}

\item{A}{for Ax+By+C=0.}

\item{B}{for Ax+By+C=0.}

\item{C}{for Ax+By+C=0.}

\item{p1}{if A, B, C are not given, you can also give two points 
p1 and p2 on the supposed Ax+By+C=0 line. Note: if A, B, C, p1, 
p2 are all given, the given A, B, C will be ignored. It must be 
a vector of length 2. The first element is x and the second is y.}

\item{p2}{see \code{p1}.}

\item{f}{argument passed to \code{split} to divide a data frame 
into a list of data frames. It should be a vector whose length is 
equal to the number of rows of x (if x is a data frame).}

\item{group}{default is TRUE. It indicates 
whether to add a 3rd column named 
"g" to label the group number of each group of points. It is useful 
when using \code{aes(...group=g)} with 'ggplot2'.}

\item{todf}{default is TRUE. It indicates whether to 
combine the output (a list) into a data frame.}

\item{checks}{default is TRUE. It indicates whether 
to check input validity. Do not turn it off unless you are sure 
that the input is OK.}
}
\value{
if \code{todf = TRUE}, the output will be a data frame
with coordinates of possibly several polygons, otherwise, 
it will be a list of data frames. Data frames have 2 columns
named "x" and "y", and if \code{group = TRUE}, a third column 
named "g" is added indicating group numbers.
}
\description{
A1 and A2 are symmetrical on the two sides of 
Ax+By+C=0. The input of the function is A1, and 
the result is A2. The function also works when the 
line is horizontal or vertical.
Note: the two shapes are symmetrical 
only when \code{ggplot2::coord_fixed()} is used.
}
\examples{
library(ggplot2)
dat1=data.frame(x=c(0, 2, 2, 0), y=c(0, 0, 1, 1))
dat2=ABCxy(dat1, -1, -1, 3)
ggplot()+
	coord_fixed()+
	geom_polygon(data=dat1, aes(x=x, y=y), fill="red")+
	geom_polygon(data=dat2, aes(x=x, y=y), fill="blue")+
	geom_abline(intercept=3, slope=-1)		
dat3=ABCxy(dat1, p1=c(0, 1), p2=c(-0.5, 0), todf=TRUE)
ggplot()+
	coord_fixed()+
	geom_polygon(data=dat1, aes(x=x, y=y), fill="red")+
	geom_polygon(data=dat3, aes(x=x, y=y), fill="blue")+
	geom_abline(intercept=1, slope=2)
}
