% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enlarge_raster.R
\name{enlarge_raster}
\alias{enlarge_raster}
\title{Enlarge a Color Matrix}
\usage{
enlarge_raster(x, n = c(10, 10))
}
\arguments{
\item{x}{a color matrix or raster. It should
have at least 1 row and 1 column with no NAs.}

\item{n}{a vector with 2 numbers. If it has 1 number, 
the number will be repeated twice. The two numbers 
indicate how many colors you will get in the result per 
row and per column. Default is \code{c(10, 10)}.}
}
\description{
This is a convenient wrapper of 
\code{colorRampPalette} to enlarge 
a color matrix or raster.
}
\examples{
library(ggplot2)
# the original matrix
m=matrix(c(
	"red", "yellow", "green", 
	"blue", "purple", "cyan", 
	"black", "orange", "grey"), byrow=TRUE, nrow=3)
# enlarge the matrix
mm=enlarge_raster(m, c(15, 15))
ggplot()+xlim(0, 10)+ylim(0, 5)+coord_fixed()+
	annotation_raster(mm, 
		xmin=0, xmax=10, ymin=0, ymax=5, interpolate=TRUE)
}
