% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{isColor}
\alias{isColor}
\title{Check whether color specifications exists.}
\usage{
isColor(x, return.colors = FALSE)
}
\arguments{
\item{x}{Vector of any of the three kinds of R color specifications, 
i.e., either a color name (as listed by 
\code{\link[grDevices]{palette}colors()}), a hexadecimal string of the form 
"#rrggbb" or "#rrggbbaa" (see rgb), or a positive integer i meaning 
\code{\link[grDevices]{palette}()[i]}.}

\item{return.colors}{Logical: logical values (FALSE, default) or 
returning colors (TRUE)}
}
\value{
Logical value (or colors)
}
\description{
Function to check whether all specified colors are 
actual colors.
}
\examples{
# correct color definitions:
isColor(c("#FF0000FF", "#00FF00FF", "#0000FFFF"))
isColor(c('red', 'steelblue', "green3"))
isColor(c(1,7,28))
# mixtures are possible too:
isColor(c("#FF0000FF", "red", 1, "#FF0000", rgb(.1,0,0)))

# return colors:
# note that 28 is converted to 4...
isColor(c(1,7,28), return.colors=TRUE) 
isColor(c("#FF0000CC", "red", 1, "#FF0000"), return.colors=TRUE)

# 4 incorrect colors, 1 correct:
test <- c("#FH0000", 3, "#FF00991", "lavendel", "#AABBCCFFF")
isColor(test)
isColor(test, return.colors=TRUE)

}
\author{
Jacolien van Rij
}
\seealso{
Other Utility functions: \code{\link{findAbsMin}},
  \code{\link{find_n_neighbors}},
  \code{\link{getArrowPos}}, \code{\link{getDec}},
  \code{\link{getRange}}, \code{\link{getRatioCoords}},
  \code{\link{group_sort}}, \code{\link{inch2coords}},
  \code{\link{list2str}}, \code{\link{move_n_point}},
  \code{\link{se}}
}

