% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/P2XB.R
\name{P2XB}
\alias{P2XB}
\alias{P2XB_cat3logit}
\alias{P2XB_ord3logit}
\title{Compute the linear predictors implied by trinomial probability distributions}
\usage{
P2XB_cat3logit(P)

P2XB_ord3logit(P, alpha)
}
\arguments{
\item{P}{object of class \code{matrix} (or other coercible classes) such that
\eqn{P\in[0,\,1]^{n\times 3}}.}

\item{alpha}{\code{numeric} vector of length two where constants \eqn{\alpha^{(1)}}
and \eqn{\alpha^{(2)}} are stored (only for ordinal models), as
defined in Equation (7) of Santi, Dickson and Espa (2019).}
}
\value{
Numeric matrix \eqn{\textbf{R}^{n\times 2}} of linear predictors.
}
\description{
Given the probability distributions \eqn{P\in[0,\,1]^{n\times 3}} of the
dependent variable, it computes the the values of linear predictors
\eqn{XB\in\textbf{R}^{n\times 2}} according to notation used in Santi,
Dickson and Espa (2019).
}
\references{
Santi F., M. M. Dickson, G. Espa (2019)
"A graphical tool for interpreting regression coefficients of trinomial logit
models", \emph{The American Statistician}, \strong{73}(2), pp. 200-207.
\doi{10.1080/00031305.2018.1442368}
}
\seealso{
\code{\link{XB2P}}.
}
\keyword{internal}
