% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plink_files.R
\name{read_plink_files}
\alias{read_plink_files}
\title{A function to read in PLINK files using \code{bigsnpr} methods}
\usage{
read_plink_files(
  data_dir,
  data_prefix,
  rds_dir,
  outfile,
  parallel,
  overwrite,
  quiet
)
}
\arguments{
\item{data_dir}{The path to the bed/bim/fam data files, \emph{without} a trailing "/" (e.g., use \code{data_dir = '~/my_dir'}, \strong{not} \code{data_dir = '~/my_dir/'})}

\item{data_prefix}{The prefix (as a character string) of the bed/fam data files (e.g., \code{prefix = 'mydata'})}

\item{rds_dir}{The path to the directory in which you want to create the new '.rds' and '.bk' files. Defaults to \code{data_dir}}

\item{outfile}{Optional: the name (character string) of the prefix of the logfile to be written. Defaults to 'process_plink', i.e. you will get 'process_plink.log' as the outfile.}

\item{parallel}{Logical: should the computations within this function be run in parallel? Defaults to TRUE. See \code{count_cores()} and \code{?bigparallelr::assert_cores} for more details.
In particular, the user should be aware that too much parallelization can make computations \emph{slower}.}

\item{overwrite}{Logical: if existing \code{.bk}/\code{.rds} files exist for the specified directory/prefix, should these be overwritten? Defaults to FALSE. Set to TRUE if you want to change the imputation method you're using, etc.}

\item{quiet}{Logical: should messages be printed to the console? Defaults to TRUE}
}
\value{
'.rds' and '.bk' files are created in \code{data_dir}, and \code{obj} (a \code{bigSNP} object) is returned. See \code{bigsnpr} documentation for more info on the \code{bigSNP} class.
}
\description{
A function to read in PLINK files using \code{bigsnpr} methods
}
\keyword{internal}
