% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_bigsnp.R
\name{subset_filebacked}
\alias{subset_filebacked}
\title{A helper function to subset \code{big.matrix} objects}
\usage{
subset_filebacked(X, new_file, complete_samples, ns, rds_dir, outfile, quiet)
}
\arguments{
\item{X}{A filebacked \code{big.matrix} with the to-be-standardized design matrix}

\item{new_file}{Optional user-specified new_file for the to-be-created .rds/.bk files.}

\item{complete_samples}{Numeric vector with indicesmarking the rows of the original data which have a non-missing entry in the 6th column of the \code{.fam} file}

\item{ns}{Numeric vector with the indices of the non-singular columns
This vector is created in \code{handle_missingness()}}

\item{rds_dir}{The path to the directory in which you want to create the new '.rds' and '.bk' files. Defaults to \code{data_dir}}

\item{outfile}{Optional: the name (character string) of the new_file of the logfile to be written. Defaults to 'process_plink', i.e. you will get 'process_plink.log' as the outfile.}

\item{quiet}{Logical: should messages be printed to the console? Defaults to FALSE (which leaves the print messages on...)}
}
\value{
A list with two components. First, a \code{big.matrix} object, 'subset_X', representing a design matrix wherein:
\itemize{
\item rows are subset according to user's specification in \code{handle_missing_phen}
\item columns are subset so that no constant features remain -- this is important for standardization downstream
The list also includes the integer vector 'ns' which marks which columns of the original matrix were 'non-singular' (i.e. \emph{not} constant features).
The 'ns' index plays an important role in \code{plmm_format()} and \code{untransform()} (both helper functions in model fitting)
}
}
\description{
A helper function to subset \code{big.matrix} objects
}
\keyword{internal}
