% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-summary-plmm.R
\name{print.summary.plmm}
\alias{print.summary.plmm}
\title{A function to print the summary of a \code{plmm} model}
\usage{
\method{print}{summary.plmm}(x, ...)
}
\arguments{
\item{x}{A \code{summary.plmm} object}

\item{...}{Not used}
}
\value{
Nothing is returned; instead, a message is printed to the console
summarizing the results of the model fit.
}
\description{
A function to print the summary of a \code{plmm} model
}
\examples{
lam <- rev(seq(0.01, 1, length.out=20)) |> round(2) # for sake of example
admix_design <- create_design(X = admix$X, outcome_col = admix$y)
fit <- plmm(design = admix_design, lambda = lam)
fit2 <- plmm(design = admix_design, penalty = "SCAD", lambda = lam)
print(summary(fit, idx = 18))
print(summary(fit2, idx = 18))
}
