% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_pi.R
\name{piest}
\alias{piest}
\alias{print.piest}
\alias{summary.piest}
\alias{print.summary.piest}
\title{Chamberlain estimator and test for fixed effects}
\usage{
piest(formula, data, subset, na.action, index = NULL, robust = TRUE, ...)

\method{print}{piest}(x, ...)

\method{summary}{piest}(object, ...)

\method{print}{summary.piest}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  subset = NULL,
  ...
)
}
\arguments{
\item{formula}{a symbolic description for the model to be estimated,}

\item{data}{a \code{data.frame},}

\item{subset}{see \code{\link[=lm]{lm()}},}

\item{na.action}{see \code{\link[=lm]{lm()}},}

\item{index}{the indexes,}

\item{robust}{if \code{FALSE}, the error as assumed to be spherical,
otherwise, a robust estimation of the covariance matrix is computed,}

\item{\dots}{further arguments.}

\item{object, x}{an object of class \code{"piest"} and of class \code{"summary.piest"}
for the print method of summary for piest objects,}

\item{digits}{number of digits for printed output,}

\item{width}{the maximum length of the lines in the printed output,}
}
\value{
An object of class \code{"piest"}.
}
\description{
General estimator useful for testing the within specification
}
\details{
The Chamberlain method consists in using the covariates of all the
periods as regressors. It allows to test the within specification.
}
\examples{

data("RiceFarms", package = "plm")
pirice <- piest(log(goutput) ~ log(seed) + log(totlabor) + log(size), RiceFarms, index = "id")
summary(pirice)

}
\references{
\insertRef{CHAM:82}{plm}
}
\seealso{
\code{\link[=aneweytest]{aneweytest()}}
}
\author{
Yves Croissant
}
\keyword{htest}
