% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crandb-public-api.R
\name{cran_new}
\alias{cran_new}
\title{New CRAN packages}
\usage{
cran_new(from = "last-week", to = "now", last = Inf)
}
\arguments{
\item{from}{Start of the time interval to query. Possible values:
\itemize{
\item \code{"last-week"}
\item \code{"last-month"}
\item A \link{Date} object to be used as a start date.
\item A \link{POSIXt} object to be used as the start date.
\item A \link{difftime} object to used as the time interval until now.
\item An integer scalar, the number of days until today.
\item A character string that is converted to a start date using
\code{\link[=as.POSIXct]{as.POSIXct()}}.
}}

\item{to}{End of the time interval to query. It accepts the same kinds
of values as \code{from}, and additionally it can also be the string \code{"now"},
to specify the current date and time.}

\item{last}{Integer to limit the number of returned packages.}
}
\value{
Data frame of package descriptions.
}
\description{
List the latest new CRAN packages.
}
\examples{
\dontrun{
# Last week
cran_new("last-week")

# Last month
cran_new("last-month")

# Last 5 days
cran_new(from = 5)

# From a given date, but at most 10
cran_new(from = "2021-04-06", last = 10)

# March of 2021
cran_new(from = "2021-03-01", to = "2021-04-01")
}
}
