% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphClasses.R
\name{DirectedGraphMeasures}
\alias{DirectedGraphMeasures}
\title{Measures for Directed Graph Class}
\description{
Descriptions for all available node and graph measures for
   networks modeled by \link{DirectedGraph}.
}
\section{Node Measures}{

\describe{
    \item{\bold{\code{outDegree}}}{outdegree, the number of outward edges (tail ends).
    Calculated by \code{\link[igraph:degree]{igraph::degree}}.
    [\href{https://en.wikipedia.org/wiki/Directed_graph#Indegree_and_outdegree}{Wikipedia}]}
    \item{\bold{\code{inDegree}}}{indegree, number of inward edges (head ends).
    Calculated by \code{\link[igraph:degree]{igraph::degree}}.
    [\href{https://en.wikipedia.org/wiki/Directed_graph#Indegree_and_outdegree}{Wikipedia}]}
    \item{\bold{\code{outCloseness}}}{closeness centrality (out), a measure of
    path lengths to other nodes along edge directions.
    Calculated by \code{\link[igraph:closeness]{igraph::closeness}}.
    [\href{https://en.wikipedia.org/wiki/Closeness_centrality}{Wikipedia}]}
    \item{\bold{\code{inCloseness}}}{closeness centrality (in), a measure of
    path lengths to other nodes in reverse of edge directions.
    Calculated by \code{\link[igraph:closeness]{igraph::closeness}}.
    [\href{https://en.wikipedia.org/wiki/Closeness_centrality}{Wikipedia}]}
    \item{\bold{\code{numRecursiveDeps}}}{number recursive dependencies, i.e., count of all nodes reachable by following edges
    out from this node.
    Calculated by \code{\link[igraph:neighborhood.size]{igraph::neighborhood.size}}.
    [\href{https://en.wikipedia.org/wiki/Rooted_graph}{Wikipedia}]}
    \item{\bold{\code{numRecursiveRevDeps}}}{number of recursive reverse dependencies (dependents), i.e., count all nodes reachable by following edges
    into this node in reverse direction.
    Calculated by \code{\link[igraph:neighborhood.size]{igraph::neighborhood.size}}.
    [\href{https://en.wikipedia.org/wiki/Rooted_graph}{Wikipedia}]}
    \item{\bold{\code{betweenness}}}{betweenness centrality, a measure of
    the number of shortest paths in graph passing through this node
    Calculated by \code{\link[igraph:betweenness]{igraph::betweenness}}.
    [\href{https://en.wikipedia.org/wiki/Betweenness_centrality}{Wikipedia}]}
    \item{\bold{\code{pageRank}}}{Google PageRank.
    Calculated by \code{\link[igraph:page_rank]{igraph::page_rank}}.
    [\href{https://en.wikipedia.org/wiki/PageRank}{Wikipedia}]}
    \item{\bold{\code{hubScore}}}{hub score from Hyperlink-Induced Topic
    Search (HITS) algorithm.
    Calculated by \code{\link[igraph:hub_score]{igraph::hub_score}}.
    [\href{https://en.wikipedia.org/wiki/HITS_algorithm}{Wikipedia}]}
    \item{\bold{\code{authorityScore}}}{authority score from
    Hyperlink-Induced Topic Search (HITS) algorithm.
    Calculated by \code{\link[igraph:authority_score]{igraph::authority_score}}.
    [\href{https://en.wikipedia.org/wiki/HITS_algorithm}{Wikipedia}]}
}
}

\section{Graph Measures}{

\describe{
    \item{\bold{\code{graphOutDegree}}}{graph freeman centralization for
    outdegree. A measure of the most central node by outdegree in relation to
    all other nodes.
    Calculated by \code{\link[igraph:centralize]{igraph::centralize}}.
    [\href{https://en.wikipedia.org/wiki/Centrality#Freeman_centralization}{Wikipedia}]}
    \item{\bold{\code{graphInDegree}}}{graph Freeman centralization for
    indegree. A measure of the most central node by indegree in relation to
    all other nodes.
    Calculated by \code{\link[igraph:centralize]{igraph::centralize}}.
    [\href{https://en.wikipedia.org/wiki/Centrality#Freeman_centralization}{Wikipedia}]}
    \item{\bold{\code{graphOutClosness}}}{graph Freeman centralization for
    out-closeness. A measure of the most central node by out-closeness in relation to
    all other nodes.
    Calculated by \code{\link[igraph:centralize]{igraph::centralize}}.
    [\href{https://en.wikipedia.org/wiki/Centrality#Freeman_centralization}{Wikipedia}]}
    \item{\bold{\code{graphInCloseness}}}{graph Freeman centralization for
    outdegree. A measure of the most central node by outdegree in relation to
    all other nodes.
    Calculated by \code{\link[igraph:centralize]{igraph::centralize}}.
    [\href{https://en.wikipedia.org/wiki/Centrality#Freeman_centralization}{Wikipedia}]}
    \item{\bold{\code{graphBetweennness}}}{graph Freeman centralization for
    betweenness A measure of the most central node by betweenness in relation to
    all other nodes.
    Calculated by \code{\link[igraph:centralize]{igraph::centralize}}.
    [\href{https://en.wikipedia.org/wiki/Centrality#Freeman_centralization}{Wikipedia}]}
}
}

\concept{Graph Classes}
\keyword{internal}
