% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\title{plot a pkggraph object}
\usage{
plot(x, ...)
}
\arguments{
\item{x}{plot object generated by \code{\link{neighborhood_graph}} or
\code{\link{make_neighborhood_graph}}}

\item{...}{additional arguments (See details)}
}
\description{
plot a pkggraph object
}
\details{
\itemize{ \item \code{background}: "black" or "white". Default is
  `black` \item \code{nodeImportance}: "in", "out" or "both", in - Node will
  be considered important(and increased size) if more incoming. out - Node
  will be considered important if more outgoing. both - Node importance will
  be calculated on both incoming and outgoing. True for all the nodes.
  Default is `both` \item \code{edgeLabel}: logical. TRUE if edge label has
  to be shown. Default is FALSE}
}
\examples{
\dontrun{
  pkggraph::init()
  plot_obj <- pkggraph::neighborhood_graph("hash")
  plot(plot_obj)

  plot_obj <- pkggraph::neighborhood_graph("tidytext")
  plot(plot_obj
       , background     = "white"
       , nodeImportance = "out")
  plot_obj <- pkggraph::neighborhood_graph(c("hash","tokenizers")
                                           , interconnect = FALSE
                                           )
  plot(plot_obj,  background = "white")
  }
}
\seealso{
\code{\link{neighborhood_graph}},
  \code{\link{make_neighborhood_graph}}, \code{\link{get_neighborhood}}
}
\author{
Nikhil Singh
}
