% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filecache.R
\name{get_cache_dir}
\alias{get_cache_dir}
\title{Get the absolute path of the package cache.}
\usage{
get_cache_dir(pkg_info)
}
\arguments{
\item{pkg_info, }{named list. Package identifier, see get_pkg_info() on how to get one.}
}
\value{
string. The absolute path of the package cache. It is constructed by calling `rappdirs::user_data_dir` with the package, author, and version if available. If the author is null, the package name is also used as the author name.
}
\description{
Get the absolute path of the package cache.
}
\examples{
    pkg_info = get_pkg_info("mypackage")
    opt_data_dir = get_cache_dir(pkg_info)


}
