% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sysreqsdocs.R
\name{sysreqs_db_list}
\alias{sysreqs_db_list}
\title{List contents of the system requirements DB, for a platform}
\usage{
sysreqs_db_list(sysreqs_platform = NULL)
}
\arguments{
\item{sysreqs_platform}{System requirements platform. If \code{NULL}, then the
\code{sysreqs_platform} \eval{man_config_link("configuration option")}
is used, which defaults to the current platform. Set this option if
\eval{.packageName} does not detect your platform correctly.}
}
\value{
Data frame with columns:
\itemize{
\item \code{name}: cross platform system dependency name in the database.
\item \code{patterns}: one or more regular expressions to match to
\code{SystemRequirements} fields.
\item \code{packages}: one or more system package names to install.
\item \code{pre_install}: command(s) to run before installing the packages.
\item \code{post_install}:: command(s) to run after installing the packages.
}
}
\description{
It also tries to update the system dependency database, if it is
outdated. (I.e. older than allowed in the \code{metadata_update_after}
\eval{man_config_link("configuration option")}.
}
\examples{
\dontshow{if (Sys.getenv("IN_PKGDOWN") == "true") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sysreqs_db_list(sysreqs_platform = "ubuntu-22.04")
\dontshow{\}) # examplesIf}
}
\seealso{
Other system requirements functions: 
\code{\link{sysreqs_check_installed}()},
\code{\link{sysreqs_db_match}()},
\code{\link{sysreqs_db_update}()},
\code{\link{sysreqs_install_plan}()},
\code{\link{sysreqs_is_supported}()},
\code{\link{sysreqs_list_system_packages}()},
\code{\link{sysreqs_platforms}()}
}
\concept{system requirements functions}
