% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.dust.R
\name{print.dust}
\alias{print.dust}
\alias{print.dust_list}
\title{Print A \code{dust} Table}
\usage{
\method{print}{dust}(x, ..., asis = TRUE, linebreak_at_end = 2)

\method{print}{dust_list}(x, ..., asis = TRUE)
}
\arguments{
\item{x}{An object of class \code{dust}}

\item{...}{Additional arguments to pass to the print method.  Currently ignored.}

\item{asis}{A logical value that controls if the output is printed using
\code{knitr::asis_output}.  See Details.}

\item{linebreak_at_end}{Used only in HTML tables; defines the number of 
line break tags \code{</br>} appended to the end of the table in order to 
generate whitespace between then end of the table and the subsequent
element.  By default, two line breaks are used.}
}
\description{
Apply the formatting to a \code{dust} object and print the table.
}
\details{
The printing format is drawn from \code{options()$dustpan_output} and may take any of
  the values \code{"console"}, \code{"markdown"}, \code{"html"}, or \code{"latex"}
  
  The markdown, html, and latex output is returned via \code{\link[knitr]{asis_output}},
  which forces the output into the 'asis' environment.  It is intended to work 
  with Rmarkdown, and the tables will be rended regardless of the 
  chunk's \code{results} argument.  Currently, there is no way to to capture
  the code for additional post processing.
  
  When \code{asis = TRUE} (the default), the output is returned via \code{knitr::asis_output},
  which renders the output as if the chunk options included \code{results = 'asis'}.  Under 
  this setting, the table will be rendered regardless of the value of the \code{results} 
  option.  Using \code{asis = FALSE} returns a character string with the code for the table.
  This may be rendered in a markdown document via \code{cat(print(x, asis = FALSE))} with the 
  chunk option \code{results = 'asis'}.  (If working with an Rnw file, the chunk option is 
  \code{results = tex}).  The only way to use the \code{asis} argument is with an explicit
  call to \code{print.dust}.
}
\examples{
dust(lm(mpg ~ qsec + factor(am), data = mtcars))
}
\author{
Benjamin Nutter
}

