% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pitches}
\alias{pitches}
\title{Sample PITCHf/x Data Set}
\format{A data frame with variables from the 'atbat' and 'pitch' tables.}
\usage{
pitches
}
\description{
Every four-seam and cutting fastball thrown by Mariano
Rivera and Phil Hughes during the 2011 season.
}
\examples{
#This can reproduce data(pitches), but it takes a while...
\dontrun{
data <- scrape(start="2011-01-01", end="2011-12-31")
names <- c("Mariano Rivera", "Phil Hughes")
atbats <- subset(data$atbat, pitcher_name \%in\% names)
pitchFX <- plyr::join(atbats, data$pitch, by=c("num", "url"), type="inner")
pitches <- subset(pitchFX, pitch_type \%in\% c("FF", "FC"))
}
}
\seealso{
\url{http://fastballs.wordpress.com/2007/08/02/glossary-of-the-gameday-pitch-fields/}
}
\keyword{datasets}

