% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_alignment_with_n_mutations.R
\name{sim_alignment_with_n_mutations}
\alias{sim_alignment_with_n_mutations}
\title{Converts a phylogeny to a random DNA alignment}
\usage{
sim_alignment_with_n_mutations(
  phylogeny,
  root_sequence,
  n_mutations,
  mutation_rate = 1,
  site_model = beautier::create_jc69_site_model(),
  max_n_tries = 100,
  verbose = FALSE
)
}
\arguments{
\item{phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{root_sequence}{the DNA sequence at the root of the phylogeny.
By default, this will consist out of an equal amount of each letter
Use \link{check_root_sequence} to check if a root sequence is valid.}

\item{n_mutations}{the number of different base pairs between
root sequence and the resulting alignment. Set to \link{NA} if
any number of mutations is fine.}

\item{mutation_rate}{the mutation rate per base pair per time unit.
Use \link{check_mutation_rate} to check if a mutation rate is valid.}

\item{site_model}{a nucleotide substitution model,
which can be:
\itemize{
  \item{
    A standard nucloetide substitution model,
    as created by \link[beautier]{create_site_model}
  }
  \item{
    \code{lns}: a linked node-substitution model
  }
  \item{
    \code{uns}: an unlinked node-substitution model
  }
}}

\item{max_n_tries}{number of attempts to simulate a DNA alignment
with the desired number of mutations. If this number of attempts is
reached, the funcion will show a \link{warning} and return
the last DNA alignment simulated.}

\item{verbose}{if TRUE, show more output}
}
\value{
an alignment

an alignment of type \code{DNAbin}
}
\description{
The function is used to create both
the true (see \link{create_true_alignment})
and twin alignment (see \link{sim_twin_alignment}).
}
\examples{
# Create the phylogeny to simulate the alignment on
n_taxa <- 5
phylogeny <- ape::rcoal(n_taxa)

# Use default settings to create the alignment
alignment_params <- create_alignment_params()

# Simulate the alignment
alignment <- sim_true_alignment(
   true_phylogeny = phylogeny,
   alignment_params = alignment_params,
 )
check_alignment(alignment)
}
\seealso{
Use \link{create_tral_file}
to save the simulated alignment directly to a file.

Use \link{sim_tral_with_std_nsm}
simulate the true alignment with a standard site model.
Use \link{sim_twal_with_std_nsm}
simulate the twin alignment with a standard site model.
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno

Richèl J.C. Bilderbeek
}
