% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pir_params.R
\name{create_test_pir_params}
\alias{create_test_pir_params}
\title{Create a set of testing parameters for \link{pirouette}}
\usage{
create_test_pir_params(
  alignment_params = create_test_alignment_params(),
  twinning_params = NA,
  experiments = list(create_test_experiment()),
  error_measure_params = create_error_measure_params(),
  evidence_filename = NA,
  verbose = FALSE
)
}
\arguments{
\item{alignment_params}{parameters to simulate an alignment,
as can be created by \link{create_alignment_params}}

\item{twinning_params}{can be \code{NA} if no twinning is desired,
or can be the twinning parameters,
as can be created by \link{create_twinning_params}}

\item{experiments}{a list of one or more \link{pirouette} experiments,
as can be created by \link{create_experiment}. If more than one experiment
is provided and a "generative" experiment is part of them, the "generative"
one has to be the first in the list. See also:
\itemize{
  \item Use \link{check_experiments} to check the list of
    experiments for validity
  \item Use \link{create_all_experiments} to create experiments with
    all combinations of tree model, clock model and tree priors
  \item Use \link{create_all_bd_experiments} to create experiments
    with all combinations of tree model, clock model and tree priors,
    except for only using birth-death tree priors
  \item Use \link{create_all_coal_experiments} to create all experiments
    with all combinations of tree model, clock model and tree priors,
    except for only coalescent tree priors
  \item Use \link{shorten_experiments} to shorten the run time
    of the list of experiments
}}

\item{error_measure_params}{parameter set to specify how the
error between the given phylogeny and the Bayesian
posterior is determined.
Use \link{create_error_measure_params} to create such
a parameter set}

\item{evidence_filename}{filename to store the estimated
evidences (aka marginal likelihoods),
as can be created by \link{get_temp_evidence_filename}.
Must be \link{NA} if there is evidence
estimation (as determined by \link{will_measure_evidence}).}

\item{verbose}{if TRUE, show more output}
}
\value{
a list with all \link{pirouette} parameters
}
\description{
Create a set of testing parameters for \link{pirouette}
}
\examples{
if (rappdirs::app_dir()$os != "win" &&
  beautier::is_on_ci() &&
  is_beast2_installed()
) {
  pir_params <- create_test_pir_params()
  check_pir_params(pir_params)

  pir_out <- pir_run(
    phylogeny = ape::read.tree(text = "((A:1, B:1):1, C:2);"),
    pir_params = pir_params
  )
  pir_plot(pir_out)
}
}
\seealso{
Use \link{create_test_pir_params_setup} to create
a test \code{pir_params} following a specific setup, such as
having a candidate experiemnt and/or use twinning.
}
\author{
Richèl J.C. Bilderbeek
}
