% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piqp.R
\name{piqp_model}
\alias{piqp_model}
\title{The PIQP Solver Model Class}
\description{
This class wraps around the PIQP C++ Solver and
exposes methods and fields of the C++ object. Users will never
need to directly create instances this class and should use the
more user-friendly functions \code{\link[=piqp]{piqp()}} and \code{\link[=solve_piqp]{solve_piqp()}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-piqp_model-new}{\code{piqp_model$new()}}
\item \href{#method-piqp_model-solve}{\code{piqp_model$solve()}}
\item \href{#method-piqp_model-update}{\code{piqp_model$update()}}
\item \href{#method-piqp_model-get_settings}{\code{piqp_model$get_settings()}}
\item \href{#method-piqp_model-get_dims}{\code{piqp_model$get_dims()}}
\item \href{#method-piqp_model-update_settings}{\code{piqp_model$update_settings()}}
\item \href{#method-piqp_model-clone}{\code{piqp_model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-piqp_model-new"></a>}}
\if{latex}{\out{\hypertarget{method-piqp_model-new}{}}}
\subsection{Method \code{new()}}{
Create a new piqp_model object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{piqp_model$new(
  P,
  c,
  A,
  b,
  G,
  h,
  x_lb,
  x_ub,
  settings = list(),
  dense_backend,
  dims
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{dense or sparse matrix of class dgCMatrix or coercible into such, must be positive semidefinite}

\item{\code{c}}{numeric vector}

\item{\code{A}}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{\code{b}}{numeric vector}

\item{\code{G}}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{\code{h}}{numeric vector}

\item{\code{x_lb}}{a numeric vector of lower bounds}

\item{\code{x_ub}}{a numeric vector of upper bounds}

\item{\code{settings}}{list with optimization parameters}

\item{\code{dense_backend}}{a flag indicating if the dense solver is to be used}

\item{\code{dims}}{the dimensions of the problem, a named list containing \code{n}, \code{p} and \code{m}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a piqp_model object that can be used to solve the QP
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-piqp_model-solve"></a>}}
\if{latex}{\out{\hypertarget{method-piqp_model-solve}{}}}
\subsection{Method \code{solve()}}{
Solve the QP model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{piqp_model$solve()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a list containing the solution
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-piqp_model-update"></a>}}
\if{latex}{\out{\hypertarget{method-piqp_model-update}{}}}
\subsection{Method \code{update()}}{
Update the current piqp_model with new data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{piqp_model$update(
  P = NULL,
  c = NULL,
  A = NULL,
  b = NULL,
  G = NULL,
  h = NULL,
  x_lb = NULL,
  x_ub = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{dense or sparse matrix of class dgCMatrix or coercible into such, must be positive semidefinite}

\item{\code{c}}{numeric vector}

\item{\code{A}}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{\code{b}}{numeric vector}

\item{\code{G}}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{\code{h}}{numeric vector}

\item{\code{x_lb}}{a numeric vector of lower bounds}

\item{\code{x_ub}}{a numeric vector of upper bounds}

\item{\code{settings}}{list with optimization parameters}

\item{\code{dense_backend}}{a flag indicating if the dense solver is to be used}

\item{\code{dims}}{the dimensions of the problem, a named list containing \code{n}, \code{p} and \code{m}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-piqp_model-get_settings"></a>}}
\if{latex}{\out{\hypertarget{method-piqp_model-get_settings}{}}}
\subsection{Method \code{get_settings()}}{
Obtain the current settings for this model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{piqp_model$get_settings()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-piqp_model-get_dims"></a>}}
\if{latex}{\out{\hypertarget{method-piqp_model-get_dims}{}}}
\subsection{Method \code{get_dims()}}{
Obtain the dimensions of this model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{piqp_model$get_dims()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-piqp_model-update_settings"></a>}}
\if{latex}{\out{\hypertarget{method-piqp_model-update_settings}{}}}
\subsection{Method \code{update_settings()}}{
Update the current settings with new values for this model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{piqp_model$update_settings(new_settings = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_settings}}{a list of named values for settings, default empty list; see \code{\link[=piqp_settings]{piqp_settings()}} for a comprehensive list of defaults}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-piqp_model-clone"></a>}}
\if{latex}{\out{\hypertarget{method-piqp_model-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{piqp_model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
