% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin-delete.R
\name{pin_delete}
\alias{pin_delete}
\title{Delete a pin}
\usage{
pin_delete(board, names, ...)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_connect]{board_connect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{names}{The names of one or more pins to delete}

\item{...}{Additional arguments passed on to methods for a specific board.}
}
\description{
Delete a pin (or pins), removing it from the board
}
\examples{
board <- board_temp()
board \%>\% pin_write(1:5, "x")
board \%>\% pin_write(mtcars)
board \%>\% pin_write(runif(1e6), "y")
board \%>\% pin_list()

board \%>\% pin_delete(c("x", "y"))
board \%>\% pin_list()
}
