% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\docType{methods}
\name{print}
\alias{print}
\alias{print,pim-method}
\alias{print,pim.environment-method}
\alias{print,pim.poset-method}
\alias{print,pim.formula-method}
\title{Print methods for the different object types}
\usage{
print(x, ...)

\S4method{print}{pim}(x, digits = max(3L, getOption("digits") - 3L),
  show.vcov = FALSE, ...)

\S4method{print}{pim.environment}(x, digits = max(3L, getOption("digits") -
  3L), n = 6L, ...)

\S4method{print}{pim.poset}(x, digits = max(3L, getOption("digits") - 3L),
  n = 6L, ...)

\S4method{print}{pim.formula}(x, digits = max(3L, getOption("digits") - 3L),
  ...)
}
\arguments{
\item{x}{the object}

\item{...}{arguments passed to other methods. Currently ignored}

\item{digits}{an integer that defines the number of digits printed}

\item{show.vcov}{a logical value indicating whether the variance-
covariance matrix should be shown or not. Defaults to \code{FALSE}}

\item{n}{number of observations shown by \code{print}}
}
\value{
invisible NULL
}
\description{
Printing \code{pim}, \code{pim.environment}, \code{pim.formula} and
\code{pim.poset} objects.
}
\examples{
data(FEVData)
Model <- pim(FEV~ Smoke*Sex , data=FEVData)
print(Model)
print(penv(Model))
# You get the drift

}
