% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_rand.R
\name{ps_rand}
\alias{ps_rand}
\title{Null model randomization analysis of alpha diversity metrics}
\usage{
ps_rand(
  ps,
  metric = "all",
  fun = "quantize",
  method = "curveball",
  n_rand = 100,
  spatial = TRUE,
  n_cores = 1,
  progress = interactive(),
  ...
)
}
\arguments{
\item{ps}{\code{phylospatial} object.}

\item{metric}{Character vector giving one or more diversity metrics to calculate; see \link{ps_diversity}
for options. Can also specify \code{"all"} (the default) to calculate all available metrics.}

\item{fun}{Null model function to use. Must be either "tip_shuffle", "nullmodel", "quantize", or an actual function:
\itemize{
\item "tip_shuffle": randomly shuffles the identities of terminal taxa
\item "nullmodel": uses \link[vegan]{nullmodel} and \link[vegan]{simulate.nullmodel}, from the vegan
package, which offer a wide range of randomization algorithms with different properties.
\item "quantize": (the default) deploys the function \link{quantize}, a routine that is itself
a wrapper around \link[vegan]{nullmodel}, allowing the use of binary algorithms for quantitative data.
\item Any other function that accepts a community matrix as its first argument and returns a
randomized version of the matrix.
}}

\item{method}{One of the method options listed under \link[vegan]{commsim}. If \code{fun = "quantize"}, this must
be one of the "binary" methods. If \code{fun = "nullmodel"}, be sure to select a method that is appropriate to
your community \code{data_type} (binary, quantitative, abundance). This argument is ignored if \code{fun} is
\code{"tip_shuffle"} or if it is a custom function.}

\item{n_rand}{Integer giving the number of random communities to generate.}

\item{spatial}{Logical: should the function return a spatial object (TRUE, default) or a matrix (FALSE).}

\item{n_cores}{Integer giving the number of compute cores to use for parallel processing.}

\item{progress}{Logical: should a progress bar be displayed?}

\item{...}{Additional arguments passed to \link{quantize}, \link[vegan]{simulate.nullmodel}, or custom function
\code{fun}. Note that the \code{nsim} argument the former two functions should not be used here; specify \code{n_rand} instead.}
}
\value{
A matrix with a row for every row of \code{x}, a column for every metric specified in \code{metric}, and
values indicating the proportion of randomizations in which the observed diversity metric was greater than
the randomized metric. Or if \code{spatial = TRUE}, a \code{sf} or \code{SpatRaster} object containing these data.
}
\description{
This function compares phylodiversity metrics calculated in \link{ps_diversity} to their null distributions
computed by randomizing the community matrix or shuffling the tips of the phylogeny, indicating statistical
significance under the assumptions of the null model. Various null model algorithms are available for
binary, probability, and count data.
}
\examples{
\donttest{
# simulate a `phylospatial` data set and run randomization with default settings
ps <- ps_simulate(data_type = "prob")
rand <- ps_rand(ps)

# using the default `quantize` function, but with alternative arguments
rand <- ps_rand(ps, transform = sqrt, n_strata = 4, priority = "rows")

# using binary data
ps2 <- ps_simulate(data_type = "binary")
rand <- ps_rand(ps2, fun = "nullmodel", method = "r2")

# using abundance data, and demonstrating alternative metric choices
ps3 <- ps_simulate(data_type = "abund")
rand <- ps_rand(ps3, metric = c("ShPD", "SiPD"), fun = "nullmodel", method = "abuswap_c")
rand
}
}
\seealso{
\code{\link[=ps_diversity]{ps_diversity()}}
}
