%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  ./PhyloSimSource.R
% 
% by the Rdoc compiler part of the R.oo package.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 \name{Event}
\docType{class}
\alias{Event}


 \title{The Event class}

 \description{

	This is the class representing an event. Event objects usually are generated by the \code{getEventsAtSite.*}
	methods based on the state of attached Site object and the properties of the generating Process object.

	The Perform method will refuse to modify target objects if the position field is not set. The Perform method can
	be called only once for any Event object.

	Package:   \cr
\bold{Class Event}\cr

\code{\link[R.oo]{Object}}\cr
\code{~~|}\cr
\code{~~+--}\code{\link{PSRoot}}\cr
\code{~~~~~~~|}\cr
\code{~~~~~~~+--}\code{Event}\cr

\bold{Directly known subclasses:}\cr
\cr

public static class \bold{Event}\cr
extends \link{PSRoot}\cr


 }

 \usage{Event(name=NA, rate=NA, site=NA, position=NA, process=NA, handler=NA, ...)}

 \arguments{
 	\item{name}{The name of the Event object. Often stores useful information.}
 	\item{rate}{The rate of the event.}
 	\item{site}{The associated Site object.}
 	\item{position}{The position of associated Site object in the enclosing Sequence object (if any).}
	\item{process}{The generator Process object.}
	\item{handler}{The handler function for the Event object. It will be called by \code{Perform.Event} with the Event object as an argument to make the changes corresponding to the event.}
 	\item{...}{Not used.}
	}

 \section{Fields and Methods}{
 	\bold{Methods:}\cr
\tabular{rll}{
 \tab \code{as.character} \tab  -\cr
 \tab \code{checkConsistency} \tab  -\cr
 \tab \code{getHandler} \tab  -\cr
 \tab \code{getName} \tab  -\cr
 \tab \code{getPosition} \tab  -\cr
 \tab \code{getProcess} \tab  -\cr
 \tab \code{getRate} \tab  -\cr
 \tab \code{getSite} \tab  -\cr
 \tab \code{getWriteProtected} \tab  -\cr
 \tab \code{is} \tab  -\cr
 \tab \code{Perform} \tab  -\cr
 \tab \code{setHandler} \tab  -\cr
 \tab \code{setName} \tab  -\cr
 \tab \code{setPosition} \tab  -\cr
 \tab \code{setProcess} \tab  -\cr
 \tab \code{setRate} \tab  -\cr
 \tab \code{setSite} \tab  -\cr
 \tab \code{setWriteProtected} \tab  -\cr
 \tab \code{summary} \tab  -\cr
}


 \bold{Methods inherited from PSRoot}:\cr
checkConsistency, enableVirtual, getComments, getMethodsList, globalConsistencyCheck, intersect.list, is.na, is, ll, my.all.equal, plot, setComments, setMethodsList, summary, virtualAssignmentForbidden

 \bold{Methods inherited from Object}:\cr
as.character, attachLocally, attach, clearCache, clearLookupCache, clone, detach, equals, extend, finalize, gc, getEnvironment, getFieldModifier, getFieldModifiers, getFields, getInstantiationTime, getStaticInstance, hasField, hashCode, ll, load, [[<-, [[, $<-, $, objectSize, print, registerFinalizer, save

 }

 \examples{
	# Note: the following examples are not very useful
	# unless you want to implement your own process.

	# create a Sequence object and a Process object
	seq<-NucleotideSequence(string="A");
	p<-Process(alphabet=NucleotideAlphabet())
	# get the Site object from the Sequence object
	s<-seq$sites[[1]]
	# attach p to s
	attachProcess(s,p)
	# create an Event object
	e<-Event(name="A->G",rate=0.1,site=s,process=p,position=1)
	# get object summary
	summary(e)
	# get event name
	e$name
	# set/get event rate
	e$rate<-0.2
	e$rate
	# get site
	e$site
	# set/get event handler
	e$.handler<-function(this){this$.site$state<-"G"}
	e$handler
	# perform the event
	Perform(e)
	# check the state of the target site
	s$state
 }

 \author{Botond Sipos}

 \seealso{
 	Site Process Sequence getEventsAtSite.GeneralSubstitution
 }
