% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_species.R
\name{indicators}
\alias{indicators}
\title{Top driving species in phyloregions}
\usage{
indicators(
  theta,
  top_indicators = 5,
  method = c("poisson", "bernoulli"),
  options = c("min", "max"),
  shared = FALSE
)
}
\arguments{
\item{theta}{A matrix or data.frame of cluster probability distributions
from a topics modeling.}

\item{top_indicators}{Integer to obtain the top driving species in
clusters.}

\item{method}{The model assumption for KL divergence measurement.
Available choices are "poisson" (default) and "bernoulli".}

\item{options}{Option "min" selects species that maximize the minimum
KL divergence of a phyloregion vs all other phyloregions.
Option "max" selects species that maximize the maximum KL divergence
of a phyloregion against all other phyloregions.}

\item{shared}{Logical if TRUE, lists top species driving patterns
in more than one phyloregion.}
}
\value{
A list of top indicator species and their indicator values
}
\description{
This function applies a KL-divergence approach to a list of indicator
species in phyloregions.
}
\examples{
data(africa)
indsp <- indicators(africa$theta, top_indicators = 5,
                    options = "max", method = "poisson")
}
\keyword{bioregion}
